<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.leave_summary")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.leave_summary")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.employee')); ?></strong>
                                        <?php echo Form::select('emp_id',$user,null,  ['class' => 'form-control select2','autocomplete' => 'off','id' => 'emp_id']); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.from_date')); ?></strong>
                                        <?php echo Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','autocomplete' => 'off','','id' => 'from_date')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.to_date')); ?></strong>
                                        <?php echo Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','autocomplete' => 'off','','id' => 'end_date')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div style="text-align: right;">
                                        
                                    </div>
                                </div>
                                
                            </div>
                            <table id="print_table" width="100%" class="table table-striped table-hover display nowrap" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th rowspan="2" style="text-align: center;">#</th>
                                        <th rowspan="2" style="text-align: center;"><?php echo e(__('administrator.code')); ?></th>
                                        <th rowspan="2" style="text-align: center;"><?php echo e(__('administrator.employee')); ?></th>
                                        <th rowspan="2" style="text-align: center;"><?php echo e(__('administrator.join_date')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.annual_leave')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.sick_leave')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.special_leave')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.unpaid_leave')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.maternity')); ?></th>
                                        <th colspan="3" style="text-align: center;"><?php echo e(__('administrator.other_leave')); ?></th>
                                    </tr>
                                    <tr>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
            
                                        <th><?php echo e(__('administrator.all')); ?></th>
                                        <th><?php echo e(__('administrator.use')); ?></th>
                                        <th><?php echo e(__('administrator.bal')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            function get_data(employee='',from_date='',end_date)
            {
                $('#print_table').DataTable({
                    ordering: false,
                    serverSide: true,
                    searching : false,
                    lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                    "buttons": [
                        {
                            extend: '',
                            text: 'Search',
                            className: "btn btn-sm btn-primary",
                            titleAttr: 'Search',
                            attr:{
                                id: 'id-search',
                                onclick: 'search()'
                            }
                        },
                        {
                            extend: 'copy',
                            text: window.copyButtonTrans,
                            className: "btn btn-sm btn-primary",
                            titleAttr: 'Copy',
                        },
                        {
                            extend: 'csv',
                            text: window.csvButtonTrans,
                            className: "btn btn-sm btn-success",
                            titleAttr: 'CSV',
                        },
                        {
                            extend: 'excel',
                            text: window.excelButtonTrans,
                            className: "btn btn-sm btn-success",
                            titleAttr: 'Excel',
                        },
                        {
                            extend: 'pdf',
                            text: window.pdfButtonTrans,
                            className: "btn btn-sm btn-danger",
                            titleAttr: 'PDF',
                        },
                        {
                            extend: '',
                            text: 'Print',
                            className: "btn btn-sm btn-info",
                            titleAttr: 'Print',
                            attr:{
                                id: 'id-print',
                                onclick: 'print()'
                            }
                        }
                    ],
                    dom: 'Blfrtip',
                    ajax: {
                        url:"<?php echo e(route('get-report-leave-summary')); ?>",
                        data:{
                            "employee" : employee,
                            "from_date" : from_date,
                            "end_date" : end_date
                        }
                    },
                    columns:
                        [
                            {data: 'DT_RowIndex'},
                            {data: 'emp_code','searchable': false},
                            {data: 'emp_id','searchable': false},
                            {data: 'joined_date','searchable': false},
                            {data: 'annual_leave','searchable': false},
                            {data: 'annual_leave_use','searchable': false},
                            {data: 'annual_leave_bal','searchable': false},
                            {data: 'sick_leave','searchable': false},
                            {data: 'sick_leave_use','searchable': false},
                            {data: 'sick_leave_bal','searchable': false},
                            {data: 'special_leave','searchable': false},
                            {data: 'special_leave_use','searchable': false},
                            {data: 'special_leave_bal','searchable': false},
                            {data: 'unpaid_leave','searchable': false},
                            {data: 'unpaid_leave_use','searchable': false},
                            {data: 'unpaid_leave_bal','searchable': false},
                            {data: 'maternity_leave','searchable': false},
                            {data: 'maternity_leave_use','searchable': false},
                            {data: 'maternity_leave_bal','searchable': false},
                            {data: 'other_leave','searchable': false},
                            {data: 'other_leave_use','searchable': false},
                            {data: 'other_leave_bal','searchable': false},
                        ],
                    "scrollX": true
                });
                $.fn.dataTable.ext.errMode = 'throw';
            }

            get_data();

            $('.button_search').on('click',function (e)
            {
                e.preventDefault();
                var employee = $('select[name="emp_id"]').find(':selected').val();
                var from_date = $('#from_date').val();
                var end_date = $('#end_date').val();
                $('#print_table').DataTable().destroy();
                get_data(employee,from_date,end_date);
            });
        });

        function print()
        {
            var title=`Report Leave Summary`;
            var user_name = "<?php echo e(Auth::user()->name); ?>";
            var date = "<?php echo e(\Globals::date_khmers(date('d-m-Y'))); ?>";
            var table_data = $("#print_table").html();
            print_report(title,table_data,user_name,date);// Refference at master page
        }
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/report-attendance/leave-summary.blade.php ENDPATH**/ ?>