<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.User List")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.User Management")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.User")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User-Create')): ?>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('users.create')); ?>"><?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <?php endif; ?>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-user" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Email")); ?></th>
                  <th><?php echo e(__("application.Role")); ?></th>
                  <th><?php echo e(__("application.Position")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                   <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($key+1); ?></td>
                      <td><?php echo e($user->name); ?></td>
                      <td><?php echo e($user->email); ?></td>
                      <td>
                        <?php if(!empty($user->getRoleNames())): ?>
                          <?php $__currentLoopData = $user->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <label class="badge badge-success"><?php echo e($v); ?></label>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                      </td>
                      <td><?php echo e($user->position); ?></td>
                      <td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User-Edit')): ?>
                         <a class="btn btn-md btn-primary" title="view and Edit" href="<?php echo e(route('users.edit',$user->id)); ?>"><i class="fa fa-eye"></i></a>
                        <?php endif; ?>

                          <?php echo Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']); ?>

                            <div class="modal fade" id="modal-danger<?php echo e($user->id); ?>">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">Delete User</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">Are you sure want to delete this User?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> OK</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                          <?php echo Form::close(); ?>

                          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User-Change-Status')): ?>
                            <?php echo $status[$key]; ?>

                          <?php endif; ?>
                          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User-Delete')): ?>
                            <?php if($user->status_delete==1): ?>
                              <a class="btn btn-md btn-danger" data-toggle="modal" type="button" title="Delete" href="#modal-danger<?php echo e($user->id); ?>"><i class="fa fa-trash"></i></a>
                            <?php else: ?>
                              <button class="btn btn-md btn-danger" disabled title="Delete"><i class="fa fa-trash"></i></button>
                            <?php endif; ?>
                          <?php endif; ?>
                      </td>
                    </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  $(document).ready(function(){
    $("#datable-user").DataTable();
  });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "<?php echo e(route('user.update_status',':id')); ?>";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"<?php echo e(csrf_token()); ?>"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/users/index.blade.php ENDPATH**/ ?>