<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.employee-rotate.modal-show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('hr.employee-rotate.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.rotate")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.rotate")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.code')); ?></th>
                                        <th><?php echo e(__('administrator.khmer_name')); ?></th>
                                        <th><?php echo e(__('administrator.english_name')); ?></th>
                                        <th><?php echo e(__('administrator.rotate_date')); ?></th>
                                        <th><?php echo e(__('administrator.current_branch')); ?></th>
                                        <th><?php echo e(__('administrator.current_department')); ?></th>
                                        <th><?php echo e(__('administrator.current_position')); ?></th>
                                        <th><?php echo e(__('administrator.to_branch')); ?></th>
                                        <th><?php echo e(__('administrator.to_department')); ?></th>
                                        <th><?php echo e(__('administrator.to_position')); ?></th>
                                        <th><?php echo e(__('administrator.reason')); ?></th>
                                        <th><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn-delete', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $(document).on('click', '.btn-show', function(){
                var id = $(this).data('id');
                var route = "<?php echo e(route('hr.show-rotate',':id')); ?>";
                route = route.replace(':id', id);
                $.ajax({
                    url: route,
                    type: 'GET',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        id: id
                    },
                    success: function(data){

                        var old_date = data.rotate_date ? data.rotate_date : "";
                        var arr = old_date.split('-');
                        var new_date = arr[2]+'-'+arr[1]+'-'+arr[0];

                        var current_branch      = data.from_branch != null ? data.from_branch.english_name : "";
                        var current_department  = data.from_department != null ? data.from_department.english_name : "";
                        var current_position    = data.from_position != null ? data.from_position.english_name : "";

                        var to_branch           = data.to_branch != null ? data.to_branch.english_name : "";
                        var to_department       = data.to_department != null ? data.to_department.english_name : "";
                        var to_position         = data.to_position != null ? data.to_position.english_name : "";

                        $('#code').val(data.code);
                        $('#khmer_name').val(data.name_kh);
                        $('#english_name').val(data.name);
                        $('#rotate_date').val(new_date);
                        $('#current_branch').val(current_branch);
                        $('#current_department').val(current_department);
                        $('#current_position').val(current_position);
                        $('#to_branch').val(to_branch);
                        $('#to_department').val(to_department);
                        $('#to_position').val(to_position);
                        $('#reason').val(data.reason);
                        
                        $('#form-show').modal('show');
                    },
                    error: function(){
                        console.log('error');
                    }
                });

            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: '<?php echo e(route("datatable.get-retation")); ?>',
                columns:
                [
                    {
                        data: 'DT_RowIndex', 
                        searchable: false
                    },
                    {
                        data: 'code'
                    },
                    {
                        data: 'name_kh'
                    },
                    {
                        data: 'name'
                    },
                    {
                        data: 'rotate_date'
                    },
                    {
                        data: 'current_branch'
                    },
                    {
                        data: 'current_department'
                    },
                    {
                        data: 'current_position'
                    },
                    {
                        data: 'transfer_branch'
                    },
                    {
                        data: 'transfer_department'
                    },
                    {
                        data: 'transfer_position'
                    },
                    {
                        data: 'reason'
                    },
                    {
                        data: 'action',
                        searchable: false
                    },

                ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/employee-rotate/index.blade.php ENDPATH**/ ?>