<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hr.attendance-finger-print.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('hr.attendance-finger-print.import-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.attendance')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.attendance')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Attendance Finger Create')): ?>
                                    <a href="<?php echo e(route('hr-attendance-fingerprint.create')); ?>" class="btn btn-sm btn-success" ><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                                <a href="javascript:void(0);" class="btn btn-sm btn-info btn_import"><span class="fa fa-file-import"></span> <?php echo e(__('administrator.import')); ?></a>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_finger_print" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.finger_name')); ?></th>
                                        <th><?php echo e(__('administrator.fingerprint_no')); ?></th>
                                        <th><?php echo e(__('administrator.check_in_out')); ?></th>
                                        <th><?php echo e(__('administrator.check_type')); ?></th>
                                        <th><?php echo e(__('administrator.type')); ?></th>
                                        <th style="width: 200px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $(document).on('click','.btn_import', function(){
                $('#form-import').modal('show');
            });

            $(document).on('click', '.btn_finger_print', function(e){
                e.preventDefault();
                var route = '<?php echo e(route("hr.get-attendance-finger-print")); ?>';

                $.ajax({
                    url:route,
                    method:'GET',
                    data:{

                    },
                    success:function(response){
                        if(response.success){
                            alert(response.message);
                        }else{
                            alert("Error");
                        }
                    },
                    error:function(error){
                        console.log(error);
                    }
                });
            });

            $('#datatable_finger_print').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "<?php echo e(route('hr-attendance-fingerprint.index')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'finger_print_name'},
                        {data: 'finger_print_no'},
                        {data: 'check_in_out'},
                        {data: 'check_type'},
                        {data: 'attend_type'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }

            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/attendance-finger-print/index.blade.php ENDPATH**/ ?>