<?php $__env->startSection('content'); ?>
    <?php Fun::lang() ?>
    <?php echo $__env->make('hr.take-leave.modal-status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('hr.take-leave.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.take_leave')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.take_leave')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Take Leave Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(url('take-leave/create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_take_leave" class="table table-striped table-bordered table-hover nowrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Employee</th>
                                        <th>From date</th>
                                        <th>To date</th>
                                        <th>Request date</th>
                                        <th>Request to</th>
                                        <th>Leave type</th>
                                        <th>Total Leave</th>
                                        <th>Review</th>
                                        <th style="width: 200px;">Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_delete', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $(document).on('click', '.btn_status', function () {
                var id = $(this).data('id');
                $('#id').val(id);
                $('#form-status').modal('show');
            });

            $('#datatable_take_leave').DataTable({
                ordering: false,
                processing: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: '<?php echo e(route("take-leave.index")); ?>',
                columns: [
                    {data: 'DT_RowIndex', searchable: false},
                    {data: 'emp_id'},
                    {data: 'from_date'},
                    {data: 'to_date'},
                    {data: 'request_date'},
                    {data: 'request_to'},
                    {data: 'leave_type'},
                    {data: 'num_take_leave'},
                    {data: 'review'},
                    {data: 'action', searchable: false},
                ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/take-leave/index.blade.php ENDPATH**/ ?>