<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.Report")); ?> <?php echo e(__("application.Commission")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Report")); ?> <?php echo e(__("application.Commission")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php echo $__env->make("report.operation.commission-form-search",compact("categories","projects","items"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-commission" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th width="90px"><?php echo e(__("application.Date")); ?></th>
                  <th><?php echo e(__("application.Item")); ?></th>
                  <th><?php echo e(__("application.Project")); ?></th>
                  <th><?php echo e(__("application.Category")); ?></th>
                  <th><?php echo e(__("application.Agency")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Agency")); ?> <?php echo e(__("application.Phone")); ?></th>
                  <th><?php echo e(__("application.Gender")); ?></th>
                  <th><?php echo e(__("application.Commission")); ?> <?php echo e(__("application.Amount")); ?>($)</th>
                  <th><?php echo e(__("application.Amount")); ?> <?php echo e(__("application.Available")); ?>($)</th>
                  <th><?php echo e(__("application.Amount")); ?> <?php echo e(__("application.Withdraw")); ?>($)</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
                <tfoot1>
                  <tr id='footer-data'>
                    <td colspan="8" class="text-right"><?php echo e(__("application.Total")); ?></td>
                    <td id="Principle"></td>
                    <td id="Interest"></td>
                    <td id="total-pay"></td>
                  </tr>
                </tfoot1>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  $(document).on("change","#project-id",function(){
    $.ajax({
      url:"<?php echo e(route('operation.get_commission')); ?>",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"<?php echo e(csrf_token()); ?>",
        "request_type":"project",
        "project_id":$(this).val(),
        "category_id":$("category-id").val()
      },
      success:function(data){
        $("#item-id").empty();
        var opt = `<option value="">
                        Please Select
                     </option>`;
          $("#item-id").append(opt);
        $.each(data,function(index,val){
          var opt = `<option value="${val.id}">
                        ${val.name}
                     </option>`;
          $("#item-id").append(opt);
        });
      }
    });
  });
  $(document).ready(function() {
      $('.main-spinner').show();
       var commission_amount;var amount_available;var amount_withdraw;
      $('#datable-commission').DataTable({  
          "autoWidth": false,
          ordering: false,
          responsive: false, 
          serverSide: true,
          "searching": false,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: {
            url:"<?php echo e(route('operation.get_commission')); ?>",
            type:"GET",
            data:function(d){
              var category_id = $("#category-id").val();
              var item_id = $("#item-id").val();
              var project_id = $("#project-id").val();
              var agency_gender = $("#agency-gender").val();
              var agency_name = $("#agency-name").val();
              var agency_phone = $("#agency-phone").val();
              var start_date = $("#start-date").val();
              var end_date = $("#end-date").val();

              d.category_id=category_id;
              d.item_id=item_id;
              d.project_id=project_id;
              d.agency_gender=agency_gender;
              d.agency_name=agency_name;
              d.agency_phone=agency_phone;
              d.start_date=start_date;
              d.end_date=end_date;
            }
          },
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'date','searchable': false},
              {data: 'item_name','name':'nso007_item_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'agency_name','name':'nso007_agency.name'}, 
              {data: 'agency_phone','name':'nso007_agency.phone'},  
              {data: 'agency_gender','name':'nso007_agency.gender'} ,
              {data:'commission_amount','searchable': false},
              {data:'amount_available','searchable': false},
              {data:'amount_withdraw','searchable': false},
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
              // $("#datable-commission").append(`<tr id='footer-data'>
              //       <td colspan="8" class="text-right"><?php echo e(__("application.Total")); ?></td>
              //       <td id="Principle">$${commission_amount}</td>
              //       <td id="Interest">$${amount_available}</td>
              //       <td id="total-pay">$${amount_withdraw}</td>
              //     </tr>`);
          },
          'footerCallback': function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
  

            commission_amount = api
                .column( 8 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            amount_available = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            amount_withdraw = api
                .column( 10 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
            $("#Principle").html(currentcyFormat(commission_amount));
            $("#Interest").html(currentcyFormat(amount_available));
            $("#total-pay").html(currentcyFormat(amount_withdraw));
        }
      }); 
      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on('click','#search-form',function() {
    $('#datable-commission').DataTable().draw(true);
  });
  // $(document).on('click','#search-form',function() {
  //         $(".main-spinner").show();
  //         var category_id = $("#category-id").val();
  //         var item_id = $("#item-id").val();
  //         var project_id = $("#project-id").val();
  //         var agency_gender = $("#agency-gender").val();
  //         var agency_name = $("#agency-name").val();
  //         var agency_phone = $("#agency-phone").val();
  //         var start_date = $("#start-date").val();
  //         var end_date = $("#end-date").val();
  //         $.ajax({
  //           url:"<?php echo e(route('operation.get_commission')); ?>",
  //           type:"POST",
  //           dataType:"JSON",
  //           data:{
  //             "_token":"<?php echo e(csrf_token()); ?>",
  //             "category_id":category_id,
  //             "item_id":item_id,
  //             "project_id":project_id,
  //             "agency_gender":agency_gender,
  //             "agency_name":agency_name,
  //             "agency_phone":agency_phone,
  //             "start_date":start_date,
  //             "end_date":end_date
  //           },
  //           success:function (data) {
  //             $(".main-spinner").hide();
  //             $("#datable-commission tbody").empty();
  //             var commission_amount=0;var amount_available=0;var amount_withdraw=0;
  //             $.each(data['commission'],function (index,val) {
  //               commission_amount+=Number(val.commission_amount);
  //               amount_available+=Number(val.amount_available);
  //               amount_withdraw+=Number(val.amount_withdraw);
  //               var tr = `<tr>
  //                           <td>${index+1}</td>
  //                           <td>${val.date.split("-")[2]+"-"+val.date.split("-")[1]+"-"+val.date.split("-")[0]}</td>
  //                           <td>${val.item_name}</td>
  //                           <td>${val.project_name}</td>
  //                           <td>${val.category_name}</td>
  //                           <td>${val.agency_name}</td>
  //                           <td>${val.agency_phone}</td>
  //                           <td>${val.agency_gender}</td>
  //                           <td>$${val.commission_amount}</td>
  //                           <td>$${val.amount_available}</td>
  //                           <td>$${val.amount_withdraw}</td>
  //                         </tr>`;

  //               $("#datable-commission tbody").append(tr);
  //             });

  //             $("#datable-commission tbody").append(`<tr id='footer-data'>
  //                 <td colspan="8" class="text-right">Total</td>
  //                 <td id="Principle">$${commission_amount}</td>
  //                 <td id="Interest">$${amount_available}</td>
  //                 <td id="total-pay">$${amount_withdraw}</td>
  //               </tr>`);

  //             $('#datable-item_info').hide();
  //             $('#datable-item_paginate').hide();
  //             $('#datable-item_length').hide();
  //           }
  //         });
  // });
  function print(){
    var title=`Report Commission`;
    var user_name = "<?php echo e(Auth::user()->name); ?>";
    var date = "<?php echo e(\Globals::date_khmers(date('d-m-Y'))); ?>";
    var table_data = $("#datable-commission").html();
    print_report(title,table_data,user_name,date);// Refference at master page
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/report/operation/commission.blade.php ENDPATH**/ ?>