<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> <?php echo e(__("application.List")); ?> <?php echo e(__("application.Purchase")); ?> <?php echo e(__("application.Detail")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Construction Management")); ?></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Purchase")); ?> <?php echo e(__("application.Detail")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-info btn-sm" onClick="javascript:history.go(-1)" style="color:white;"><span class="fa fa-reply"></span>  <?php echo e(__('application.Back')); ?></a>
              </div>
            </div>
            <div class="card-body">
              <table id="datatable-purchase-detail" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th><?php echo e(__('application.No')); ?></th>
                      <th><?php echo e(__('application.Product')); ?> <?php echo e(__('application.Code')); ?></th>
                      <th><?php echo e(__('application.Product')); ?> <?php echo e(__('application.Name')); ?></th>
                      <th><?php echo e(__('application.Unit')); ?> <?php echo e(__('application.Name')); ?></th>
                      <th><?php echo e(__('application.Category')); ?> <?php echo e(__('application.Name')); ?></th>
                      <th><?php echo e(__('application.Unit')); ?> <?php echo e(__('application.Price')); ?></th>
                      <th><?php echo e(__('application.Qty')); ?></th>
                      <th><?php echo e(__('application.Amount')); ?></th>
                      <th><?php echo e(__('application.Description')); ?></th>
                      <th><?php echo e(__('application.Action')); ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $purchase_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                          <td><?php echo e($key+1); ?></td>
                          <td><?php echo e($value->pro_code); ?></td>
                          <td><?php echo e($value->pro_name); ?></td>
                          <td><?php echo e($value->unit_name); ?></td>
                          <td><?php echo e($value->pcat_name); ?></td>
                          <td>$<?php echo e(number_format($value->unit_price,2)); ?></td>
                          <td><?php echo e($value->qty); ?></td>
                          <td>$<?php echo e(number_format($value->amount,2)); ?></td>
                          <td><?php echo e($value->remark); ?></td>
                          <td><button type="button" class="btn btn-sm btn-success" onclick="show_image(<?php echo e($value->id); ?>)" title="Show Image"><i class="fa fa-eye"></i></button></td>
                      </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>  
  $(document).ready(function() {
      $('#datatable-purchase-detail').DataTable();
  });
  function show_image(purchase_stock_id){
    var route = "<?php echo e(route('show_purchase_product_image',':id')); ?>";
    route = route.replace(":id",purchase_stock_id);
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"GET",
      dataType:"JSON",
      async:false,
      success:function(data){
        $(".main-spinner").hide();
        if(data['status']==true){
          var opt = "";
          $.each(data['image'],function(index,value){
            opt += `<div class="col-md-12" width="100%" height="50%"><img src = "${value}" width="100%"></div>`;
          });
          $.confirm({
              title: 'Image',
              content:opt,
              onContentReady: function () {
                  var self = this;
                  /*this.setContentPrepend('<div>Prepended text</div>');*/
                  /*setTimeout(function () {
                      self.setContentAppend('<div>Appended text after 2 seconds</div>');
                  }, 2000);*/
              },
              columnClass: 'medium',
          });
        }
        else{

        }
      },
      error:function(){
        $(".main-spinner").hide();
          return "Erro !"
      }
    });
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/construction-stock/purchase/purchasedetails.blade.php ENDPATH**/ ?>