<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php
        
    ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.employee_by_branch")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.employee_by_branch")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.employee')); ?></strong>
                                        <?php echo Form::select('emp_id[]', $user , null, ['class' => 'form-control select2','multiple' => 'multiple','autocomplete' => 'off']); ?>

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <strong for="" class=""><?php echo e(__('administrator.branch')); ?></strong>
                                        <?php echo Form::select('branch_id[]', $branch ,null , array('class' => 'form-control select2','multiple' => 'multiple','autocomplete' => 'off')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.department')); ?></strong>
                                        <?php echo Form::select('department_id[]', $department, null, array('class' => 'form-control select2','multiple' => 'multiple','autocomplete' => 'off')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.position')); ?></strong>
                                        <?php echo Form::select('position_id[]', $position, null, array('class' => 'form-control select2','multiple' => 'multiple', 'autocomplete' => 'off')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button class=" btn btn-sm btn-primary pull-right btn_search" type="button"><i class="fas fa-search "></i> <?php echo e(__('administrator.search')); ?></button>
                                <button class=" btn btn-sm btn-success pull-right" type="button" onclick="tableToExcel('print_tables','employee by branch')"><i class="fa fa-file-excel"></i> <?php echo e(__('administrator.excel')); ?></button>
                                <button class=" btn btn-sm btn-info pull-right" type="button" onclick="printDiv()" ><i class="fa fa-print "></i> <?php echo e(__('administrator.print')); ?></button>
                            </div>
                            <br>
                            <div>
                                <div class="col-md-12 show-report" style="height: 768px; width: 100%; background-color: #ffffff; padding: 20px; -webkit-box-shadow: 0px 6px 26px -6px rgba(0,0,0,0.48);
                                    -moz-box-shadow: 0px 6px 26px -6px rgba(0,0,0,0.48);
                                    box-shadow: 0px 6px 26px -6px rgba(0,0,0,0.48); border-radius: 5px;overflow: scroll;">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script type="text/javascript"> 
        $(document).ready(function () {
            $('.print-data').on('click',function () {
                printDiv();
            });
            $('.btn_search').on('click', function(e){
                e.preventDefault();

                var emp_id          = $('[name="emp_id[]"]').val();
                var branch_id       = $('[name="branch_id[]"]').val();
                var department_id   = $('[name="department_id[]"]').val();
                var position_id     = $('[name="position_id[]"]').val();
                var from_date       = $('[name="from_date"]').val();
                var to_date         = $('[name="to_date"]').val();
                
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                
                
                $.ajax({
                    url: "<?php echo e(route('get-employee-by-branch-show')); ?>",
                    type: 'POST',
                    async: false,
                    dataType: 'html',
                    data: {
                        emp_id: emp_id,
                        branch_id: branch_id,
                        department_id: department_id,
                        position_id: position_id,
                        from_date: from_date,
                        to_date: to_date

                    },
                    success: function (d) {
                        $('.show-report').html(d);
                    },
                    error: function (d) {
                        $.alert('Something Wrong!');
                    }
                });
  
            });
        });
        function printDiv()
        {
            var divToPrint=document.getElementById('DivIdToPrint');

            var newWin=window.open('','Print-Window');

            newWin.document.open();
            var table = `
                <html>
                    <head>
                        <style>
                            .table-data
                            {
                                width:100%;
                            }

                            .table-data,.table-data  th, .table-data  td
                            {
                                border-collapse:collapse;
                                border: 1px solid #a8a8a8;
                            }

                            .table-data  th{

                                text-align: center;
                                padding: 5px;
                            }
                            .table-data  td
                            {
                                padding: 5px;
                            }
                            .table-data  tbody > tr:nth-child(odd)
                            {
                               background-color: #f4f4f4;
                               color: #606060;
                            }
                        </style>
                    </head>
                    <body onload="window.print()">${divToPrint.innerHTML}</body>
                </html>`;

            newWin.document.write(table);

            newWin.document.close();

            setTimeout(function(){newWin.close();},10);

        }
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/report-employee/employee-by-branch.blade.php ENDPATH**/ ?>