<?php $__env->startSection("content"); ?>
<?php echo $__env->make('accounting.account-chart.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="/* min-height: 4390.14px; */">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?> <?php echo e(__("application.Account Chart")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Account Chart")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Account-Chart-Create')): ?>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('account-chart.create')); ?>"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <?php endif; ?>
            <div class="card-body">
                <table id="datatable_account_chart" class="table table-bordered table-hover nowrap">
                    <thead>
                        <tr>
                            <th><?php echo e(__('application.Account')); ?> <?php echo e(__("application.Code")); ?></th>
                            <th><?php echo e(__('application.Account')); ?> <?php echo e(__("application.Name")); ?></th>
                            <th><?php echo e(__("application.Account")); ?> <?php echo e(__('application.Name Khmer')); ?></th>
                            <th><?php echo e(__('application.Type')); ?></th>
                            <th><?php echo e(__('application.Description')); ?></th>
                            <th><?php echo e(__('application.Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($account_chart) && count($account_chart) > 0): ?>
                            <?php $__currentLoopData = $account_chart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $acc_chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($acc_chart->id); ?>">
                                    <td><?php echo e($acc_chart->id); ?></td>
                                    <td><?php echo e($acc_chart->acc_name); ?></td>
                                    <td><?php echo e($acc_chart->acc_namekh); ?></td>
                                    <td><?php echo e($acc_chart->acctype_name); ?></td>
                                    <td><?php echo e($acc_chart->acc_des); ?></td>
                                    <td><?php if($acc_chart->acc_status != 0): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Account-Chart-Edit')): ?>
                                            <a href="<?php echo e(route('account-chart.edit',$acc_chart->id)); ?>" class="btn btn-success btn-sm"><i class="fa fa-edit" title="Edit"> </i> </a>
                                            <?php endif; ?>
                                            &nbsp;
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Account-Chart-Delete')): ?>
                                            <a href="#" data-id = "<?php echo e($acc_chart->id); ?>" data-toggle="modal" data-target="#form-delete" class="btn-sm btn btn-danger confirm_delete" data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash"></i></a>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Account-Chart-Edit')): ?>
                                            <button disabled class="btn btn-success btn-sm"><i class="fa fa-edit" title="Edit"></i></button>
                                            <?php endif; ?>
                                            &nbsp;
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Account-Chart-Delete')): ?>
                                            <button class="btn-sm btn btn-danger" disabled title="Delete"><i class="fa fa-trash"></i></button>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#datatable_account_chart').DataTable({
            ordering:false,
            info:false,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
        });
        $(document).on('click','.confirm_delete',function(){
            var id = $(this).data('id');
            $('#delete-id').val(id);
            $('#form-delete').modal('show');
        });

        $('#form-delete-acc').on('submit',function (e) {
            var id = $('#delete-id').val();
            e.preventDefault();
            $.ajax({
                url:"<?php echo e(route('account-chart.delete')); ?>",
                type:"POST",
                dataType:"JSON",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    "delete_id": id
                },
                success:function (data) {
                    window.location.reload();
                    $('#form-delete').modal('hide');
                    $('#datatable_account_chart').DataTable().ajax.reload();
                    toastr['success'](data['message']);
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/account-chart/index.blade.php ENDPATH**/ ?>