<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\IncomeController;

Auth::routes();
Route::group(['middleware' => ['auth']], function() {
	Route::get('/', 'HomeController@index')->name('home');
    Route::post('/dashbord-chart-competed','HomeController@get_dashbord_chart_month_completed')->name("get_dashbord_chart_month_completed");
    Route::post('/dashbord-chart-collected','HomeController@get_dashbord_chart_month_collected')->name("get_dashbord_chart_month_collected");
    Route::post('/dashbord-chart-collection','HomeController@get_dashbord_chart_month_collection')->name("get_dashbord_chart_month_collection");
    Route::post('/dashbord-chart-income-expense','HomeController@get_income_expense')->name("get_income_expense");

    Route::get('lang/{locale}', 'HomeController@lang')->name('lang');

    Route::resource('roles','RoleController');
    Route::resource('users','UserController');
    Route::resource('products','ProductController');
    Route::resource('position','PositionController');
    Route::POST('update-position','PositionController@update_position')->name("position.update-position");
    Route::GET('update-user-status/{id}','UserController@update_status')->name('user.update_status');
    /*======================================Location==================================================*/

    Route::GET('/find-district-code/{procode}', 'FindLocationController@district');
    Route::GET('/find-commune-code/{procode}', 'FindLocationController@commune');
    Route::GET('/find-village-code/{procode}', 'FindLocationController@village');

    /*======================================Agency====================================================*/

    Route::resource('/agency',"AgencyController");
    Route::get('/index-inactive-agency',"AgencyController@index_inactive_agency")->name("agency.index_inactive_agency");
    Route::get('/agency-get-active-list','AgencyController@datatable_get_agency')->name('datatable.datatable_get_agency');
    Route::get('/agency-get-inactive-list','AgencyController@datatable_get_agency_inactive')->name('datatable.datatable_get_agency_inactive');
    Route::post("/agency-change-to-inactive","AgencyController@set_to_inactive")->name("agencies.set_to_inactive");
    Route::post("/agency-change-to-active","AgencyController@set_to_active")->name("agencies.set_to_active");
    Route::get('/delete-agency/{id}','AgencyController@delete')->name("agencies.delete");

    /*======================================Customer==================================================*/

    Route::resource('/customer',"CustomerController");
    Route::get("/get-customer-list","CustomerController@datatable_get_customer")->name("customer.datatable_get_customer");
    Route::get('/feedback/{id?}',"CustomerController@feedback")->name("customer.feedback");
    Route::post('/feedback-add',"CustomerController@add_feedback")->name("customer.add_feedback");
    Route::get("/feedback-get/{id}","CustomerController@get_feedback")->name("customer.get_feedback");
    Route::post('/feedback-update-feedback','CustomerController@update_feedback')->name("customer.update_feedback");
    Route::post('/customer-delete-feedback',"CustomerController@destroy_customer_feedback")->name("customer.destroy_customer_feedback");
    Route::post('/customer-change-to-client',"CustomerController@change_to_client")->name("customer.change_to_client");
    Route::get("/delete-customer/{id}","CustomerController@delete")->name("customer.delete");

    /*======================================Client====================================================*/

    Route::resource('/client','ClientController');
    Route::get('client-get-data','ClientController@datatable_get_client')->name('client.datatable_get_client');
    Route::get('/delete-client/{id}','ClientController@delete')->name('client.delete');
    Route::post('/store_pos_client','ClientController@store_pos_client')->name('store_pos_client');

    /*======================================Client Relationship=======================================*/

    Route::resource('/clientrelationship','ClientRelationshipController');
    Route::get('/get-client-relationship','ClientRelationshipController@datatable_get_relationship')->name("clientrelationship.datatable_get_relationship");
    Route::get('/delete-client-relationship/{id}','ClientRelationshipController@delete')->name('client_relationship.delete');

    /*======================================Category====================================================*/

    Route::resource('/category','CategoryController');
    Route::match(['get','post'],'get-category','CategoryController@get_category')->name('category.get_category');
    Route::get('get-category-delete/{id}','CategoryController@delete')->name('category.delete');

    /*======================================Project=====================================================*/

    Route::resource('/project','ProjectController');
    Route::get("/project-get","ProjectController@datatable_get_project")->name("project.datatable_get_project");
    Route::get('get-project-delete/{id}','ProjectController@delete')->name('project.delete');

    /*======================================Block=======================================================*/

    Route::resource('/block',"BlockController");
    Route::match(['get','post'],'/get-block','BlockController@get_block')->name('block.get_block');
    Route::get('get-block-delete/{id}','BlockController@delete')->name('block.delete');

    /*======================================Item===========================================*/

    Route::resource('/item',"ItemController");
    Route::match(['get','post'],"/get-item","ItemController@get_item")->name("item.get_item");
    Route::get('get-item-delete/{id}','ItemController@delete')->name('item.delete');
    Route::get('get-item-raise-price/','ItemController@raise_price')->name('item.raise_price');
    Route::get('get-item-by-zone/{id}','ItemController@get_item_by_zone')->name('get_item_by_zone');
    Route::post('store-item-raise-price/','ItemController@store_raise_price')->name('item.store_raise_price');

    /*======================================POS============================================*/

    Route::resource("/pos","POSController");
    Route::match(['get','post'],'/pos-get-item',"POSController@get_item")->name("pos.get_item");
    Route::post("/pos-add-to-cart","POSController@Add_To_Cart")->name("pos.Add_To_Cart");
    Route::post("/remove-item-from-cart","POSController@Remove_From_Cart")->name("pos.Remove_From_Cart");
    Route::post("/get-search-client","POSController@get_client_search")->name("get-client-search");
    Route::post("/get-search-agency","POSController@get_agency_search")->name("get-agency-search");

    /*======================================Deposit=======================================*/

    Route::resource('/deposit',"DepositController");
    Route::match(['get','post'],"/get-deposit-data","DepositController@get_deposit")->name("deposit.get_deposit");
    Route::post("/deposit-add-more-deposit","DepositController@add_more_deposit")->name("deposit.add_more_deposit");
    Route::post("/cancel-deposit","DepositController@cancel_deposit")->name("deposit.cancel_deposit");
    Route::get("/print-invoice-deposit/{id}","DepositController@print_invoice")->name("deposit.print_invoice");
    Route::post("/delete-deposit","DepositController@delete_deposit")->name("deposit.delete_deposit");
    Route::post("/get-all-deposit","DepositController@get_all_deposit")->name("get-all-deposit");
    Route::get("/get-item-edit-deposit","DepositController@get_item_edit")->name('deposit.get_item_edit');
    Route::post("/pos-add-to-cart-deposit","DepositController@Add_To_Cart")->name("deposit.Add_To_Cart");
    Route::post("/remove-item-from-cart-deposit","DepositController@Remove_From_Cart")->name("deposit.Remove_From_Cart");
    Route::post('/save-edit-pos',"DepositController@update_pos")->name('deposit.update_pos');
    Route::get('/edit-deposit/{id}',"DepositController@edit_deposit")->name("deposit.edit_deposit");
    Route::post('/edit-save-deposit',"DepositController@save_edit_deposit")->name("deposit.save_edit_deposit");
    Route::post("/schedule-pay_deposit","DepositController@pay_deposit")->name('schedule.pay_deposit');
    Route::get("/get_deposit_data_print/{id}","DepositController@get_deposit_data_print")->name('get_deposit_data_print');
    Route::get("/deposit-print-contract-deposit/{id}","DepositController@print_contract")->name('deposit.print_contract');
    Route::match(['get','post'],'/promotion-remark','DepositController@remark_promotion')->name('deposit.remark_promotion');

    /*======================================Installment=============================*/

    Route::get("/create-installment/{id}","InstallmentController@create")->name("installment.create");
    Route::post("/store-installment","InstallmentController@store")->name("installment.store");
    Route::get('/create-reschedule/{loan_id}','InstallmentController@edit')->name('installment.edit');
    Route::post('/update-reschedue-save','InstallmentController@update')->name("installment.update");
    Route::get('/get-detail-payment-detail-policy/{id}','InstallmentController@get_payment_policy_detail')->name('installment.get_payment_policy_detail');

    /*======================================Client Payment Controller===================*/

    Route::resource("/client-payment","ClientPaymentController");
    Route::get("/client-payment-get-index","ClientPaymentController@get_client_payment")->name("client-payment.get_client_payment");
    Route::get("/client-payment-list/{id}","ClientPaymentController@client_payment_list_detail")->name("client-payment.client_payment_list_detail");
    Route::get('/datatable-client-payment/{loan?}','ClientPaymentController@get_client_payment_detailt_list')->name('datatable.get_client_payment_detailt_list');
    Route::post("/get-data-for-payment","ClientPaymentController@get_data_for_payment")->name("datatable.get_data_for_payment");
    Route::get('/print-contract-payment/{id}',"ClientPaymentController@print_contract")->name("client-payment.print_contract");
    Route::get('/print-schedule-payment/{id}',"ClientPaymentController@print_schedule")->name('client-payment.print_schedule');
    Route::post("/add-commission-amount","ClientPaymentController@add_commission")->name("client-payment.add_commission");
    Route::post("/get-edit-commission","ClientPaymentController@get_edit_commission")->name("client-payment.get_edit_commission");
    Route::post("/save-edit-commission","ClientPaymentController@save_edit_commission")->name("client-payment.save_edit_commission");
    Route::post("/payment-method","ClientPaymentController@payment_method")->name('client-payment.payment_method');
    Route::post('/get-paid-loan-process','ClientPaymentController@get_paid_loan_process')->name('get_paid_loan_process');
    Route::get('/print-invoice-payment/{id}','ClientPaymentController@print_invoice_payment')->name("print-invoice-payment");
    Route::post('/get-view-client-relationship','ClientPaymentController@get_loan_client_relationship')->name('get_loan_client_relationship');
    Route::match(['get','post'],'/get-post-client-relationship/{id?}','ClientRelationshipController@get_post_client_relationship')->name('get_post_client_relationship'); Route::post('/add-more-contract-info','ClientPaymentController@add_more_contract_information')->name('add_more_contract_information');
    Route::get('/get-view-client-list-client/{loan_id}','ClientPaymentController@get_all_client_for_change')->name('get_all_client_for_change');
    Route::post('/get-view-client-change-client-store','ClientPaymentController@loan_client_change_store')->name('loan_client_change_store');

    Route::match(['get','post'],'/get-post-client-schedule-payment','ClientPaymentController@add_remark_schedule')->name('add_remark_schedule');
    Route::get('/client-payment-delete_payment_process','ClientPaymentController@delete_payment_process')->name('client-payment.delete_payment_process');


    /*================================Commission List======================================*/

    Route::resource('/commission',"CommissionController");
    Route::get('/get_index',"CommissionController@get_index")->name("commission.get_index");
    Route::post('/get_commission_history',"CommissionController@get_commission_history")->name("commission.get_commission_history");
    Route::get('/print-commission-invoice/{id}',"CommissionController@print_invoice_commission")->name("commission.print_invoice_commission");
    Route::post('/get-commission-info',"CommissionController@get_commission_info")->name("commission.get_commission_info");
    Route::post('/save_withdraw_commission',"CommissionController@save_withdraw_commission")->name("commission.save_withdraw_commission");

    /*=================================Deposit Cancellation================================*/

    Route::get('/deposit-cancellation','DepositCancellationController@index')->name("deposit-cancellation.index");
    Route::get('/deposit-cancellation-get','DepositCancellationController@get_index')->name("deposit-cancellation.get_index");
    /*===========================Arrears====================*/

    Route::get("/arrear","ArrearController@index")->name("arrears.index");

    Route::get("/get-arrear-data","ArrearController@get_data_index")->name("arrears.get_data_index");

    // /*===============================Journal===================================================*/
    // Route::resource("/Journal","JournalController");
    // Route::POST('search/account-code', 'JournalController@query_account_code')->name('search-account-code');
    // Route::match(['get', 'post'], '/get-journal', 'JournalController@get_journal')->name('datatable.get-journal');
    // Route::POST('/print/voucher', 'JournalController@print_voucher')->name('voucher.print');

//  Journal
    Route::resource('/journal', 'JournalController');
    Route::match(['get', 'post'], '/get-journal', 'JournalController@get_journal')->name('datatable.get-journal');
    Route::POST('search/account-code', 'JournalController@query_account_code')->name('search-account-code');

    Route::POST('/print/voucher', 'JournalController@print_voucher')->name('voucher.print');
    Route::POST('/journal-confirm-delete', 'JournalController@journal_confirm_delete')->name('journal_confirm_delete');
    Route::POST('/note-date-print-journal','JournalController@note_print_date')->name('note_print_date');
//

    //*********************************** Ledger *******************************************//
    //*************************************************************************************//
    // Route::get('/ledger/{id?}/{start?}/{end?}', 'AccountingReportsController@ledger')->name('accounting-report.ledger');
    // Route::match(['get', 'post'], '/get-accounting-report/ledger', 'AccountingReportsController@get_ledger')->name('get-accounting-report.ledger');

    //*********************************** Ledger *******************************************//
    //*************************************************************************************//
    Route::get('/ledger/{id?}/{start?}/{end?}', 'AccountingReportsController@ledger')->name('accounting-report.ledger');
    Route::match(['get', 'post'], '/get-accounting-report/ledger', 'AccountingReportsController@get_ledger')->name('get-accounting-report.ledger');
    Route::post('/ledger/print', 'AccountingReportsController@print_ledger')->name('print.ledger');

    //*********************************** Trial Balance *******************************************//
    //*************************************************************************************//
    Route::get('/get-accounting-report/trail-balance', 'AccountingReportsController@trial_balance')->name('accounting-report.trail-balance');
    Route::match(['get', 'post'], '/get-accounting-report/get-trail-balance', 'AccountingReportsController@get_trial_balance')->name('accounting-report.get-trail-balance');
    Route::POST('print-accounting-report/trial-balance', 'AccountingReportsController@print_trial_balance')->name('print.trial-balance');

    //*********************************** Balance Sheet *******************************************//
    //********************************************************************************************//
    Route::get('/get-accounting-report/balance-sheet', 'AccountingReportsController@balance_sheet')->name('accounting-report.balance-sheet');
    Route::match(['get', 'post'], '/get-accounting-report/get-balance-sheet', 'AccountingReportsController@get_balance_sheet')->name('accounting-report.get-balance-sheet');
    Route::POST('/print-accounting-report/balance-sheet', 'AccountingReportsController@print_balance_sheet')->name('print.balance-sheet');

    //*********************************** Income Statement *******************************************//
    //*************************************************************************************************************//
    Route::get('/accounting-report/income-statement', 'AccountingReportsController@income_statement')->name('accounting-report.income-statement');
    Route::match(['get', 'post'], '/accounting-report/get-income-statement', 'AccountingReportsController@get_income_statement')->name('accounting-report.get-income-statement');
    Route::POST('/print-accounting-report/income-statement', 'AccountingReportsController@print_income_statement')->name('print.income-statement');

//    cash flow
    Route::get('accounting-report/cash-flow','AccountingReportsController@cash_flow')->name('accounting-report.cash-flow');
    Route::match(['get','post'],'accounting-report/cash-flow-list','AccountingReportsController@cash_flow_list')->name('accounting-report.cash-flow-list');

    /***********************************Report Cash */
    Route::get('/accounting-report-cash','AccountingReportsController@cash_report')->name("accounting.cash_report");
//

    /*================================Report=============================*/
        /*==================Item Stock Report============================*/

        Route::get("/item_report","ReportController@all_item")->name("item_report.all_item");
        Route::match(['get','post'],"/item_report-get-post","ReportController@get_all_item")->name("item_report.get_all_item");

        Route::get("/item_sold_report","ReportController@sold_item")->name("item_sold_report.sold_item");
        Route::match(['get','post'],"/item_sold_report-get-post","ReportController@get_sold_item")->name("item_sold_report.get_sold_item");

        /*==================Operation Report=============================*/

        Route::get("/operation-collection-report","ReportController@collection")->name("operation.collection");
        Route::match(['get','post'],"/operation-collection-report-get","ReportController@get_collection")->name("operation.get_collection");

        Route::get("/operation-collected-report","ReportController@collected")->name("operation.collected");
        Route::match(['get','post'],"/operation-collected-report-get","ReportController@get_collected")->name("operation.get_collected");

        Route::get("/operation-completed-report","ReportController@completed")->name("operation.completed");
        Route::match(['get','post'],"/operation-completed-report-get","ReportController@get_completed")->name("operation.get_completed");

        Route::get("/operation-payment-report","ReportController@payment")->name("operation.payment");
        Route::match(['get','post'],"/operation-payment-report-get","ReportController@get_payment")->name("operation.get_payment");

        Route::get("/operation-commission-report","ReportController@commission")->name("operation.commission");
        Route::match(['get','post'],"/operation-commission-report-get","ReportController@get_commission")->name("operation.get_commission");

        Route::get("/operation-commission_history-report","ReportController@commission_history")->name("operation.commission_history");
        Route::match(['get','post'],"/operation-commission_history-report-get","ReportController@get_commission_history")->name("operation.get_commission_history");

    /**
     *  Account Type & Account Chart
     */
//    Route::GET('/account-type','AccountTypeController@account_type')->name('account.type');
    Route::resource('/account-type','AccountTypeController');
    Route::resource('/account-chart','AccountChartController');

    Route::get('/get-account-code/{acctype}','AccountChartController@get_account_code');
    Route::POST('account-chart/delete','AccountChartController@confirm_delete')->name('account-chart.delete');

    /*
     * Setting
    */
    Route::resource('/setting','SettingController');
    Route::get('/setting-commission_condition','SettingController@commission_condition')->name('commission_condition');
    Route::post('/settting-store-commission_condition','SettingController@store_commission_condition')->name('store_commission_condition');
    Route::get('/setting-get-commission-condition-for-edit/{id}','SettingController@edit_commission_condition')->name('edit_commission_condition');
    Route::post('/settting-store-edit-commission_condition','SettingController@store_edit_commission_condition')->name('store_edit_commission_condition');

    /**********************************************Item border***************************************/
    Route::match(['get','post'],'/border-get-post/{id?}','ClientPaymentController@item_border')->name('border-item');

    // construction supplier
    Route::GET('/suppliers','SupplierController@index')->name('suppliers.index');
    Route::GET('/suppliers-create','SupplierController@create')->name('suppliers.create');
    Route::GET('/suppliers-edit/{id}','SupplierController@edit')->name('suppliers.edit');
    Route::POST('/suppliers-store','SupplierController@store')->name('suppliers.store');
    Route::POST('/suppliers-update','SupplierController@update')->name('suppliers.update');

    //Category of Construction stock
    Route::resource('/category-construction','CategoryConStock');
    Route::POST('/category-construction-update','CategoryConStock@con_update')->name('construction.con_update');

    //Unit of construction stock
    Route::GET('/unit-construction','UnitConController@index')->name('unit.index');
    Route::GET('/unit-construction-create','UnitConController@create')->name('unit.create');
    Route::POST('/unit-construction-save','UnitConController@store')->name('unit.store');
    Route::POST('/unit-construction-update','UnitConController@update')->name('unit.update');

    //product of construction stock
    Route::resource('/product-construction','ProductConController');
    Route::get('/product-construction-delete/{id}','ProductConController@delete')->name('con_product.delete');
    Route::get('/show-product-image/{id}','ProductConController@show_product_image')->name('show_product_image');

    //construction stock------Purchase Proudct-------
    Route::resource('/purchases','PurchaseProductController');
    Route::get('/purchases-delete','PurchaseProductController@delete')->name("purchases.delete");
    Route::post('/get_product_by_cate_purchase','PurchaseProductController@get_product_by_cate_purchase')->name('get_product_by_cate_pur');
    Route::post('/purchasees-get-product','PurchaseProductController@get_product_by_cate')->name('get_product_by_cate');
    Route::get('/purchasees-get-product-list','PurchaseProductController@get_purchase_list')->name('get_purchase_list');
    Route::POST('/get-blogs','ItemController@get_blogs')->name("get_blogs");
    Route::get('/show-purchase-product-image/{id}','PurchaseProductController@show_purchase_product_image')->name('show_purchase_product_image');
    Route::get('/show-purchase-image/{id}','PurchaseProductController@show_purchase_image')->name('show_purchase_image');

    //Contruction stock --------using product--------------
    Route::resource('/usings',"UsingProduct");
    Route::get('/usings-delete','UsingProduct@delete')->name("usings.delete");
    Route::GET("/usings-return-to-stock","UsingProduct@return_stock")->name('usings.return_stock');
    Route::GET("/usings-get-list","UsingProduct@using_get_list")->name('usings.using_get_list');
    Route::POST("/usings-return-to-stock-store","UsingProduct@return_stock_store")->name('usings.return_stock_store');
    Route::POST("/usings-return-to-get-item","UsingProduct@return_get_item")->name('usings.return_get_item');
    Route::GET("/usings-get-item-print/{id}","UsingProduct@using_print")->name('usings.using_print');

    //Construction Report
    Route::resource('/purchase_report','PurchaseReport');
    Route::match(['GET','POST'],'/purchase_report-get','PurchaseReport@list_report_purchase')->name("list_report_purchase");
    Route::post('/purchase_report-get-print','PurchaseReport@list_report_purchase_print')->name("list_report_purchase_print");

    Route::resource('/using_report','UsingReport');
    Route::match(['get','post'],'/using_report-get','UsingReport@using_report_get')->name("using_report_get");
    Route::post('/using_report-get-print',"UsingReport@using_report_get_print")->name("using_report_get_print");

    Route::resource('/balance_report','BalanceReport');
    Route::match(['get','post'],'/balance_report-get','BalanceReport@balance_report_get')->name("balance_report_get");
    Route::post('/balance_report-get-print',"BalanceReport@balance_report_get_print")->name("balance_report_get_print");
    Route::post('/get-product-by-category',"BalanceReport@get_product_by_category")->name("get_product_by_category");
    Route::post('/get-zone-by-project',"BalanceReport@get_zone_by_project")->name("get_zone_by_project");
    /****************************************Subcategory */
    Route::resource('/sub_category','SubCategoryController');
    Route::match(['get','post'],'get-sub-category','SubCategoryController@get_subcategory')->name('sub_category.get_subcategory');
    Route::get('get-sub-category-delete/{id}','SubCategoryController@delete')->name('sub_category.delete');
    /***************************************Group Item */
    Route::resource('/group_item','GroupItemController');
    Route::match(['get','post'],'get-group-item','GroupItemController@get_group_item')->name('group_item.get_group_item');
    Route::get('get-group-item-delete/{id}','GroupItemController@delete')->name('group_item.delete');

    /*************************************Payment Policy**********************************/
    route::get("/setting-payment-policy-index","PaymentPolicyController@index")->name("payment-policy.index");
    route::post("/setting-payment-policy-store","PaymentPolicyController@store")->name("payment-policy.store");
    route::post('/setting-payment-policy-update','PaymentPolicyController@update')->name("payment-policy.update");
    route::get('/setting-payment-policy-delete','PaymentPolicyController@delete')->name("payment-policy.delete");

    /*************************************Payment Policy Detail**********************************/
    route::get('/setting-payment-policy-create','PaymentPolicyDetailController@create')->name('payment-policy-detail.create');
    route::post('/get-sub-category-item-for-payment-policy','PaymentPolicyDetailController@get_sub_category')->name('payment_policy.get_sub_category');
    route::get("/setting-payment-policy-index-detail","PaymentPolicyDetailController@index")->name("payment-policy-detail.index");
    route::post("/setting-payment-policy-store-detail","PaymentPolicyDetailController@store")->name("payment-policy-detail.store");
    route::patch('/setting-payment-policy-update-detail/{id}','PaymentPolicyDetailController@update')->name("payment-policy-detail.update");
    route::get('/setting-payment-policy-delete-detail','PaymentPolicyDetailController@delete')->name("payment-policy-detail.delete");
    route::get('/setting-payment-policy-create/{id}','PaymentPolicyDetailController@edit')->name('payment-policy-detail.edit');

    /**Get payment policy detail */
    route::post('/get-payment-policy-detail','PaymentPolicyDetailController@get_payment_policy_detail')->name('get_payment_policy_detail');
    /**Setting Bank */

    Route::resource('/setting_bank', 'BankController');
    Route::post('/setting_bank-update', 'BankController@update_store')->name('setting_bank.update_store');
    Route::get('/setting_bank-update', 'BankController@delete')->name('setting_bank.delete');

    /*******************Cancel Payment**********************/
    Route::get('/cancel-payment/{id}','ClientPaymentController@cancel_payment')->name('cancel_payment');

    /*******************Delete Payment**********************/
    Route::get('/delete-payment/{id}','ClientPaymentController@delete_payment')->name('delete_payment');

    /*******************Expense*****************************/
    Route::resource('/expense','ExpenseController');

    Route::get('/expense-list','ExpenseController@list')->name('expense.list');

    Route::get('/expense-delete','ExpenseController@delete')->name('expense.delete');

    /*******************Income******************************/
    Route::resource('/income','IncomeController');
    Route::get('/income-delete','IncomeController@delete')->name('income.delete');

    /*******************Libility******************************/
    Route::resource('/liability','LiabilityController');
    Route::get('/liability-delete','LiabilityController@delete')->name('liability.delete');

    /*******************Account Receiveable******************************/
    Route::resource('/account_receiveable','AccountReceiveableController');
    Route::get('/account_receiveable-delete','AccountReceiveableController@delete')->name('account_receiveable.delete');
    Route::get('/account_receiveable-get_pay/{id}','AccountReceiveableController@get_pay')->name('account_receiveable.get_pay');
    Route::post('/account_receiveable-save_pay','AccountReceiveableController@save_pay')->name('account_receiveable.save_pay');
    Route::get('/account_receiveable-get_view_paid/{id}','AccountReceiveableController@get_view_paid')->name('account_receiveable.get_view_paid');
    Route::get('/account_receiveable-print_invoice/{id}','AccountReceiveableController@print_invoice')->name('account_receiveable.print_invoice');
    Route::get('/account_receiveable-paid-delete','AccountReceiveableController@paid_delete')->name('account_receiveable.paid_delete');

    /*******************Account Payable******************************/
    Route::resource('/account_payable','AccountPayableController');
    Route::get('/account_payable-delete','AccountPayableController@delete')->name('account_payable.delete');
    Route::get('/account_payable-get_pay/{id}','AccountPayableController@get_pay')->name('account_payable.get_pay');
    Route::post('/account_payable-save_pay','AccountPayableController@save_pay')->name('account_payable.save_pay');
    Route::get('/account_payable-get_view_paid/{id}','AccountPayableController@get_view_paid')->name('account_payable.get_view_paid');
    Route::get('/account_payable-paid-delete','AccountPayableController@paid_delete')->name('account_payable.paid_delete');

    /*******************Withdraw******************************/
    Route::resource('/withdraw','WithdrawController');
    Route::get('/withdraw-delete','WithdrawController@delete')->name('withdraw.delete');

    /*******************Capital******************************/
    Route::resource('/capital','CapitalController');
    Route::get('/capital-delete','CapitalController@delete')->name('capital.delete');

    Route::resource('/asset','AssetController');
    Route::get('/asset-delete','AssetController@delete')->name('asset.delete');
});

