<?php

//++++++++++++++++++++++++++ Human Resource +++++++++++++++++++++++++++++
Route::group(['middleware' => ['auth'], 'namespace' => 'HR'], function () {
    Route::resource('hr-dashboard', 'HrDashboardController');
    // Route::resource('hr-company-structure', 'HrCompanyController');
    // Route::resource('hr-assets-type', 'HrAssetTypeController');
    Route::resource('hr-roles', 'HrRoleController');
    // Route::resource('hr-benefit', 'HrBenefitController');
    Route::resource('hr-candidate', 'HrCandidateController');
    Route::resource('hr-employee', 'HrEmployeeController');
    Route::resource('hr-employment-status', 'HrEmploymentStatusController');
    Route::resource('hr-exp-level', 'HrJobExpLevelController');
    Route::resource('hr-position', 'HrPositionController');
    Route::resource('hr-job-function', 'HrJobFunctionController');
    Route::resource('hr-job-post', 'HrJobPostController');
    Route::resource('hr-leave-request', 'HrLeaveRequestController');
    Route::resource('hr-leave-type', 'HrLeaveTypeController');
    Route::resource('hr-overtime-request', 'HrOvertimeRequestController');
    Route::resource('hr-travel-request', 'HrTravelRequestController');
    Route::resource('hr-work-day', 'HrWorkdayController');
    Route::resource('hr-job-benefit', 'HrJobBenefitController');
    Route::resource('hr-job-education-level', 'HrJobEducationLevelController');
    Route::resource('hr-job-employment-type', 'HrJobEmploymentTypeController');
    Route::resource('hr-generate-salary', 'HrGenSalaryController');
    Route::resource('hr-employee-benefit', 'HrEmployeeBenefitController');
    Route::resource('hr-exchange-rate', 'ExchangeRateController');
    Route::resource('hr-holiday', 'HrHolidayController');
	//  import holiday excel
    Route::post('import-holiday', 'HrHolidayController@importHoliday')->name('importHoliday');
	
    Route::resource('report-hr', 'ReportHrController');
    Route::resource('hr-evaluation', 'HrEvaluationController');
    Route::resource('hr-branch', 'HrBranchController');
    Route::resource('hr-training', 'HrTrainingController');
    Route::resource('hr-hard-skill', 'HrHardSkillController');
    Route::resource('hr-soft-skill', 'HrSoftSkillController');
    Route::resource('hr-recommendation', 'HrRecommendationController');
    Route::resource('hr-development-plan', 'HrDevelopmentPlanController');
    Route::resource('hr-resign', 'HrResignController');
    Route::resource('hr-emp-resign', 'HrEmployeeResignController');
    Route::resource('hr-emp-rotate', 'HrEmployeeRotateController');
    Route::resource('hr-emp-promote', 'HrEmployeePromoteController');
    Route::resource('hr-external-lecturer', 'ExternalLecturerController');
    Route::resource('hr-training-course', 'HrTrainingCourseController');
    Route::resource('hr-in-external-training', 'HrInExternalTrainingController');
    Route::resource('hr-emp-loan', 'HrEmployeeLoanController');
    Route::resource('report-hr-employee', 'ReportEmployeeController');
    Route::resource('hr-department', 'HrDepartmentController');
    Route::resource('hr-time-policy', 'TimePolicyController');
    Route::resource('hr-advance-salary', 'AdvanceSalaryController');

    Route::post('hr-branch-update', 'HrBranchController@update')->name('hr-branch-update');
    // Route::GET('hr-get-company-structure', 'HrCompanyController@get_company_structure')->name('datatable.hr-get-company-structure');
    Route::GET('hr-get-position', 'HrPositionController@get_position')->name('datatable.hr-get-position');
    Route::GET('hr-get-employment-status', 'HrEmploymentStatusController@get_employment_type')->name('datatable.hr-get-employment-status');
    Route::GET('hr-get-leave-type', 'HrLeaveTypeController@get_leave_type')->name('datatable.hr-get-leave-type');
    Route::GET('hr-get-leave', 'HrLeaveRequestController@get_leave')->name('datatable.hr-get-leave');
    Route::GET('hr-get-leave-staff', 'HrLeaveRequestController@get_leave_staff')->name('datatable.hr-get-leave-staff');
    Route::GET('hr-get-overtime', 'HrOvertimeRequestController@get_overtime')->name('datatable.hr-get-overtime');
    // Route::GET('hr-get-attendance', 'OldHrAttendanceController@get_attendance')->name('datatable.hr-get-attendance');
    Route::GET('hr-get-employee', 'HrEmployeeController@get_employee')->name('datatable.hr-get-employee');
    Route::GET('hr-get-travel-request', 'HrTravelRequestController@get_travel_request')->name('datatable.hr-get-travel-request');
    Route::GET('hr-get-workday', 'HrWorkdayController@get_workday')->name('datatable.hr-get-workday');
    Route::GET('hr-get-job-benefit', 'HrJobBenefitController@get_benefit')->name('datatable.hr-get-job-benefit');
    Route::GET('hr-get-job-education-level', 'HrJobEducationLevelController@get_education_level')->name('datatable.hr-get-job-education-level');
    Route::GET('hr-get-job-function', 'HrJobFunctionController@get_function')->name('datatable.hr-get-job-function');
    Route::GET('hr-get-exp-level', 'HrJobExpLevelController@get_exp_level')->name('datatable.hr-get-exp-level');
    Route::GET('hr-get-employment-type', 'HrJobEmploymentTypeController@get_employment_type')->name('datatable.hr-get-employment-type');
    Route::GET('hr-get-candidate', 'HrCandidateController@get_candidate')->name('datatable.hr-get-candidate');
    Route::GET('hr-get-job-post', 'HrJobPostController@get_job_post')->name('datatable.hr-get-job-post');
    Route::GET('hr-leave-staff', 'HrLeaveRequestController@staff_leave')->name('hr-leave-staff');
    Route::GET('hr-gen-salary', 'HrGenSalaryController@get_gen_salary')->name('datatable.hr-gen-salary');
    Route::GET('hr-get-employee-benefit', 'HrEmployeeBenefitController@get_employee_benefit')->name('datatable.hr-get-employee-benefit');
    Route::GET('hr-get-in-ex-training', 'HrInExternalTrainingController@get_in_ex_training')->name('datatable.hr-get-in-ex-training');
    Route::GET('hr-get-department', 'HrDepartmentController@get_data_department')->name('datatable.hr-get-department');
    Route::GET('hr-get-emp-resign', 'HrResignController@get_emp_resign')->name('datatable.hr-get-emp-resign');
    Route::GET('hr-get-emp-promote', 'HrEmployeePromoteController@get_emp_promote')->name('datatable.hr-get-emp-promote');
    Route::GET('hr-get-emp-loan', 'HrEmployeeLoanController@get_emp_loan')->name('datatable.hr-get-emp-loan');
    Route::GET('hr-get-emp-contract/{id?}', 'HrEmployeeController@get_emp_contract')->name('hr.get-emp-contract');
    Route::GET('hr-get-exchange-rate', 'ExchangeRateController@get_exchange_rate')->name('hr.get-exchange-rate');
    Route::GET('hr-get-holiday', 'HrHolidayController@get_holiday')->name('hr.get-holiday');


    Route::POST('hr-employee-change-status', 'HrEmployeeController@change_status')->name('hr.employee-change-status');
    Route::POST('leave-change-status', 'HrLeaveRequestController@staff_leave_status')->name('hr.leave-change-status');
    Route::POST('overtime-change-status', 'HrOvertimeRequestController@overtime_status')->name('hr.overtime-change-status');
    Route::POST('travel-change-status', 'HrTravelRequestController@travel_status')->name('hr.travel-change-status');
    Route::POST('hr-leave-request-next', 'HrLeaveRequestController@next')->name('hr-leave-request.next');
    Route::POST('hr-leave-request-next', 'HrLeaveRequestController@next')->name('hr-leave-request.next');
    Route::POST('delete-candidate', 'HrCandidateController@delete_candidate')->name('hr.delete-candidate');
    Route::POST('hr-get-benefit-type', 'HrEmployeeBenefitController@get_benefit_type')->name('hr.get-benefit-type');


    Route::GET('view-travel', 'HrTravelRequestController@view_modal')->name('hr.travel-view');
    Route::GET('view-leave', 'HrLeaveRequestController@view_modal')->name('leave.view');
    Route::GET('view-overtime', 'HrOvertimeRequestController@view_overtime')->name('hr.overtime');
    Route::GET('view-candidate', 'HrCandidateController@view_candidate')->name('hr.view-candidate');
    Route::GET('view-job-post', 'HrJobPostController@view_job_post')->name('hr.view-job-post');
    Route::POST('hr-view-job-post', 'HrJobPostController@job_post')->name('hr.hr-view-job-post');

    Route::GET('hr-generate-payroll', 'HrGenSalaryController@generate_payroll')->name('hr.generate-payroll');
    Route::GET('hr-generate-salary-destroy/{id}', 'HrGenSalaryController@destroy')->name('hr-generate-salary.destroy');
    Route::POST('hr-delete-generate', 'HrGenSalaryController@delete_generate')->name('hr.delete-generate');

    Route::POST('payroll', 'ReportHrController@viewPayroll')->name('report.payroll');
    Route::POST('payslips', 'ReportHrController@viewPaySlip')->name('report.payslip');

    Route::POST('employee-list', 'ReportEmployeeController@employeeList')->name('report.employee.list');
    Route::POST('employee-profile', 'ReportEmployeeController@employeeProfile')->name('report.employee.profile');
    Route::POST('delete-position', 'HrPositionController@delete_position')->name('delete_position');
    Route::POST('delete-branch', 'HrBranchController@delete_branch')->name('delete_branch');
    Route::POST('delete-department', 'HrDepartmentController@delete_department')->name('delete_department');

    Route::GET('hr-get-rotate', 'HrEmployeeRotateController@get_rotate')->name('datatable.get-retation');
    Route::GET('hr-show-rotate', 'HrEmployeeRotateController@show_rotate')->name('hr.show-rotate');
    Route::GET('hr-show-promote', 'HrEmployeePromoteController@show_promote')->name('hr.show-promote');

    Route::POST('delete-rotate', 'HrEmployeeRotateController@delete_rotate')->name('delete_rotate');
    Route::POST('delete-resign', 'HrResignController@delete_resign')->name('delete-resign');
    Route::POST('delete-promote', 'HrEmployeePromoteController@delete_promote')->name('delete-promote');
    Route::POST('delete-loan', 'HrEmployeeLoanController@delete_loan')->name('delete-loan');
    Route::POST('delete-benefit', 'HrEmployeeBenefitController@delete_benefit')->name('delete_benefit');
    Route::POST('delete-overtime', 'HrOvertimeRequestController@delete_overtime')->name('delete_overtime');
    Route::POST('delete-travel', 'HrTravelRequestController@delete_travel')->name('delete_travel');
    Route::POST('delete-job-benefit', 'HrJobBenefitController@delete_job_benefit')->name('delete_job_benefit');
    Route::POST('delete-exchange-rate', 'ExchangeRateController@delete_exchange_rate')->name('delete_exchange_rate');
    Route::POST('delete-employment-status', 'HrEmploymentStatusController@delete_employment_status')->name('delete_employment_status');
    Route::POST('delete-holiday', 'HrHolidayController@delete_holiday')->name('delete-holiday');
    Route::POST('delete-time-policy', 'TimePolicyController@delete_time_policy')->name('delete-time-policy');
    Route::POST('delete-advance-salary', 'AdvanceSalaryController@delete_advance_salary')->name('delete-advance-salary');

    //take leave
    Route::resource('leave-total', 'LeaveTotalController');
    Route::resource('take-leave', 'TakeLeaveController');
    Route::resource('take-leave-authorize', 'TakeLeaveAuthorizeController');
    Route::POST('deduct-status', 'TakeLeaveAuthorizeController@deduct_status')->name('deduct_status');

    Route::GET('/leave-total-generate', 'LeaveTotalController@generate');
    Route::GET('take-leave-authorize-review/{id}', 'TakeLeaveAuthorizeController@review');
    Route::post('take-leave-delete/{id}', 'TakeLeaveController@delete')->name('remove_leave');
    Route::GET('employee-total-leave-type', 'TakeLeaveController@getTotalLeaveByType');

    // vicheth
    Route::GET('take-leave-form/{id?}', 'TakeLeaveController@get_take_leave_form')->name('take-leave-form');
    Route::POST('take-leave-change-status', 'TakeLeaveController@change_status')->name('take-leave.change_status');
    Route::POST('delete-take-leave', 'TakeLeaveController@delete_take_leave')->name('delete_take_leave');
    Route::POST('take-leave-authorize-status', 'TakeLeaveAuthorizeController@change_status')->name('take-leave-authorize.change_status');
    Route::GET('hr-change-status-branch', 'HrBranchController@branch_changeStatus')->name('hr.branch_changeStatus');

    // report employee
    Route::MATCH(['get', 'post'], 'report-employee', 'ReportEmployeeController@get_report_employee')->name('get-report-employee');
    // report employee by branch
    Route::GET('report-employee-by-branch', 'ReportEmployeeController@get_employee_by_branch')->name('get-employee-by-branch');
    Route::POST('report-employee-by-branch-show', 'ReportEmployeeController@get_report_employee_by_branch')->name('get-employee-by-branch-show');
    //report annual leave
    Route::GET('report-annual-leave', 'ReportAttendanceController@get_annual_leave')->name('get-report-annual-leave');
    Route::POST('report-annual-leave-show', 'ReportAttendanceController@get_annual_leave_show')->name('get-report-annual-leave-show');
    // report attendance
    Route::MATCH(['get', 'post'], 'report-leave-by-group', 'ReportAttendanceController@leave_by_group')->name('get-report-leave-by-group');
    Route::MATCH(['get', 'post'], 'report-leave-summary', 'ReportAttendanceController@report_leave_summary')->name('get-report-leave-summary');
    Route::MATCH(['get', 'post'], 'report-attendance', 'ReportAttendanceController@get_report_attendance')->name('get-report-attendance');
    //report daily attend summary
    Route::GET('report-daily-attendance', 'ReportAttendanceController@daily_att_summary_list')->name('get-report-daily-att');
    Route::POST('report-daily-attendance-show', 'ReportAttendanceController@daily_att_summary_list_show')->name('get-report-daily-att-show');
    //report payroll
    Route::MATCH(['get', 'post'], 'report-payroll', 'ReportPayrollController@get_report_payroll')->name('get-report-payroll');
    Route::MATCH(['get', 'post'], 'report-authorize-salary-list', 'ReportPayrollController@authorize_salary_list')->name('get-report-authorize');
    //report advance salary
    Route::MATCH(['get', 'post'], 'report-advance-salary-list', 'ReportPayrollController@advance_salary_list')->name('get-report-advance');
    //report benefit
    Route::MATCH(['get', 'post'], 'report-benefit', 'ReportBenefitController@get_report_benefit')->name('get-report-benefit');
    //report payslip
    Route::GET('report-payslip', 'ReportHrController@viewPaySlip')->name('get-report-payslip');
    Route::POST('report-payslip-show', 'ReportHrController@viewPaySlipShow')->name('get.report-payslip-show');
    //attendance from fingerpint
    Route::resource('hr-attendance-fingerprint', 'AttendanceFingerPrintController');
    Route::GET('hr-get-attendance-finger-print', 'AttendanceFingerPrintController@get_data_finger_print')->name('hr.get-attendance-finger-print');
    Route::POST('delete-data-attendance', 'AttendanceFingerPrintController@delete_attendance_finger_print')->name('hr.delete-data-attendance');
    Route::POST('import-attendance-fingerprint', 'AttendanceFingerPrintController@import_attendance_fingerprint')->name('hr.import-attendance-fingerprint');

    //generate attendance
    Route::resource('hr-generate-attendance', 'GenerateAttendanceController');
    Route::POST('hr-get-generate-attendance', 'GenerateAttendanceController@get_generate_attendance')->name('hr.get-generate-attendance');
    Route::POST('delete-generate-attandance', 'GenerateAttendanceController@delete_generate_attendance')->name('delete.generate_attendance');

    //Absent Policy
    Route::resource('hr-absent-policy', 'AbsentPolicyController');
    Route::POST('hr-delete-absent-policy', 'AbsentPolicyController@delete_absent_policy')->name('hr.delete-absent-policy');

    //Salary Tax
    Route::resource('salary-tax', 'SalaryTaxController');
    Route::POST('delete-salary-tax', 'SalaryTaxController@delete_salary_tax')->name('delete_salary_tax');

    //Overtime Type
    Route::resource('overtime-type', 'OvertimeTypeController');
    Route::POST('delete-overtime-type', 'OvertimeTypeController@delete_overtime_type')->name('delete_overtime_type');

    //OT policy
    Route::resource('overtime-policy', 'OvertimePolicyController');
    Route::POST('hr-get-overtime-type', 'OvertimePolicyController@get_overtime_type')->name('hr.get_overtime_type');
    Route::POST('delete-overtime-policy', 'OvertimePolicyController@delete_overtime_policy')->name('delete_overtime_policy');

    Route::get('/Hello', function(){
        return "Hello world";
    });
});


