@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.User List")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.User Management")}}</li>
              <li class="breadcrumb-item active">{{__("application.User")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('User-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('users.create') }}">{{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-user" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Email")}}</th>
                  <th>{{__("application.Role")}}</th>
                  <th>{{__("application.Position")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                   @foreach ($data as $key => $user)
                    <tr>
                      <td>{{ $key+1 }}</td>
                      <td>{{ $user->name }}</td>
                      <td>{{ $user->email }}</td>
                      <td>
                        @if(!empty($user->getRoleNames()))
                          @foreach($user->getRoleNames() as $v)
                             <label class="badge badge-success">{{ $v }}</label>
                          @endforeach
                        @endif
                      </td>
                      <td>{{ $user->position }}</td>
                      <td>
                        @can('User-Edit')
                         <a class="btn btn-md btn-primary" title="view and Edit" href="{{ route('users.edit',$user->id) }}"><i class="fa fa-eye"></i></a>
                        @endcan

                          {!! Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                            <div class="modal fade" id="modal-danger{{$user->id}}">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">Delete User</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">Are you sure want to delete this User?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> OK</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                          {!! Form::close() !!}
                          @can('User-Change-Status')
                            {!!$status[$key]!!}
                          @endcan
                          @can('User-Delete')
                            @if($user->status_delete==1)
                              <a class="btn btn-md btn-danger" data-toggle="modal" type="button" title="Delete" href="#modal-danger{{$user->id}}"><i class="fa fa-trash"></i></a>
                            @else
                              <button class="btn btn-md btn-danger" disabled title="Delete"><i class="fa fa-trash"></i></button>
                            @endif
                          @endcan
                      </td>
                    </tr>
                   @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).ready(function(){
    $("#datable-user").DataTable();
  });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "{{route('user.update_status',':id')}}";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"{{csrf_token()}}"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
@endsection