@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Create New")}} {{__("application.User")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.User Management")}}</li>
              <li class="breadcrumb-item"><a href="{{route('users.index')}}">{{__("application.User")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Create New")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(array('route' => 'users.store','method'=>'POST')) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Name")}}:</strong>
                                    {!! Form::text('name', null, array('placeholder' => __("application.Name"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Phone")}}:</strong>
                                    {!! Form::text('phone', null, array('placeholder' => __("application.Phone"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.ID Card")}}:</strong>
                                    {!! Form::text('idcard', null, array('placeholder' => __("application.ID Card"),'class' => 'form-control')) !!}
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <strong class="required">{{__("application.Email")}}:</strong>
                                    {!! Form::text('email', null, array('placeholder' => __("application.Email"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Role")}}:</strong>
                                    {!! Form::select('roles[]', $roles,[], array('class' => 'form-control select2','required')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Gender")}}:</strong>
                                    {!! Form::select('gender', ["Male"=>"Male","Female"=>"Female"],[], array('class' => 'form-control select2','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Date of Birth")}}:</strong>
                                    {!! Form::text('dob', null, array('class' => 'form-control date_picker','placeholder'=>__("application.Date of Birth"))) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Position")}}:</strong>
                                    <select class="form-control select2" name="position" required>
                                        @foreach($position as $value)
                                            <option value="{{$value->id}}">{{$value->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Password")}}:</strong>
                                    {!! Form::password('password', array('placeholder' => __("application.Password"),'class' => 'form-control','required')) !!}
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <strong class="required">{{__("application.Confirm Password")}}:</strong>
                                    {!! Form::password('confirm-password', array('placeholder' => __("application.Confirm Password"),'class' => 'form-control','required')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <strong>{{__("application.Address")}}</strong>
                                    {!! Form::textarea('address', null, array('class' => 'form-control','placeholder'=>__("application.Address"),'rows'=>'3')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
@endsection