@extends("layouts.master")
@section("content")
<div class="modal fade" id="create-condition">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Create")}} {{__("application.Commission Condition")}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      {!! Form::open(array('route' => 'store_commission_condition','method'=>'POST')) !!}
      <div class="modal-body">
        <div class="form-group">
            <strong class="required">{{__("application.Title")}}:</strong>
            {!! Form::text('title', null, array('placeholder' =>__("application.Title"),'class' => 'form-control','required')) !!}
        </div>
        <div class="form-group">
            <strong>{{__("application.Description")}}:</strong>
            {!! Form::textarea('description', null, array('placeholder' =>__("application.Description"),'class' => 'form-control','rows'=>3)) !!}
        </div>
        <div class="form-group">
            <strong>Condition (<a href="javascript:void(0)" onclick="new_condition()"> New Condition </a>)</strong>
            <div class="table-responsive">
              <table class="table m-0">
                  <thead>
                      <tr>
                          <th>No.</th>
                          <th>Type Commission</th>
                          <th style="text-align: center;">Condition Commission($)</th>
                          <th>Withdrawable($)</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody id="tb-condition-table">
                      <tr>
                          <td>1</td>
                          <td>
                              <select class="form-control select2" name="type[]" onchange="select_type_commission_change(this)">
                                <option value="1">Booking&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                <option value="2">Monthly Payment</option>
                              </select>
                          </td>
                          <td>
                              <input type="number" class="form-control" name="condition[]" 
                              placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <input type="number" class="form-control" name="withdrawable[]" placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <button type="button" disabled class="btn btn-md btn-danger">
                                  <i class="fas fa-trash"></i>
                              </button>
                          </td>
                      </tr>
                  </tbody>
              </table>
          </div>
        </div>
      </div>
      <div class="modal-footer justify-content-between">
        <div>&nbsp;</div>
        <button type="submit" class="btn btn-success btn-sm"><i class="fa fa-save"></i> {{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!--Edot Modal-->
<div class="modal fade" id="edit-condition">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Edit")}} {{__("application.Commission Condition")}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      {!! Form::open(array('route' => 'store_edit_commission_condition','method'=>'POST')) !!}
      <div class="modal-body">
        <div class="form-group">
            <strong class="required">{{__("application.Title")}}:</strong>
            {!! Form::text('title', null, array('placeholder' =>__("application.Title"),'class' => 'form-control','required','id'=>'edit-title')) !!}
        </div>
        <div class="form-group">
            <strong>{{__("application.Description")}}:</strong>
            {!! Form::textarea('description', null, array('placeholder' =>__("application.Description"),'class' => 'form-control','rows'=>3,'id'=>'edit-description')) !!}
            <input type="hidden" name="commission_condition_id" id="commission_condition_id">
        </div>
        <div class="form-group">
            <strong>Condition (<a href="javascript:void(0)" onclick="edit_new_condition()"> New Condition </a>)</strong>
            <div class="table-responsive">
              <table class="table m-0">
                  <thead>
                     <tr>
                          <th>No.</th>
                          <th>Type Commission</th>
                          <th style="text-align: center;">Condition Commission($)</th>
                          <th>Withdrawable($)</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody id="edit-tb-condition-table">
                  </tbody>
              </table>
          </div>
        </div>
      </div>
      <div class="modal-footer justify-content-between">
        <div>&nbsp;</div>
        <button type="submit" class="btn btn-success btn-sm"><i class="fa fa-save"></i> {{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Commission Condition")}} {{__('application.List')}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Setting")}}</li>
              <li class="breadcrumb-item active">{{__("application.Commission Condition")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="#create-condition"  data-toggle="modal">{{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-commission-condition" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Title")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                   @foreach ($data as $key => $value)
                    <tr>
                      <td>{{ $key+1 }}</td>
                      <td>{{ $value->title }}</td>
                      <td>{{ $value->description }}</td>
                      <td>
                         <a class="btn btn-sm btn-primary" title="Show & Edit" href="javascript:void(0)" onclick="edit({{$value->id}})"><i class="fa fa-eye"></i></a>
                      </td>
                    </tr>
                   @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  function select_type_commission_change (obj) {
    var obj_value = $(obj).val();
    if(obj_value==1){
      $(obj).closest('tr').find("td:eq(2)").find("input").removeAttr('readonly');
    }else{
      $(obj).closest('tr').find("td:eq(2)").find("input").val(0);
      $(obj).closest('tr').find("td:eq(2)").find("input").attr('readonly',true);
    }
  }
  function edit(id)
  {
    $('.main-spinner').show();
    var route = "{{route('edit_commission_condition',':id')}}";
    route = route.replace(":id",id);
    $.ajax({
        url: route,
        type: 'GET',
        dataType: 'JSON'
      })
      .done(function(data) {
        $('.main-spinner').hide();
        $('#edit-condition').modal('show');
        $("#commission_condition_id").val(data['id']);
        $("#edit-title").val(data['commission_condition'].title);
        $("#edit-description").val(data['commission_condition'].description);
        var tr=``;
        $.each(data['commission_condition_detail'],function(index,value){
          var opt = ``;var readonly ="";
          if(value.commission_type==1){
            opt = `
                <option value="1" selected>Booking&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                <option value="2">Monthly Payment</option>`;
                readonly="";
          }else{
               opt = `
                <option value="1">Booking&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                <option value="2" selected>Monthly Payment</option>`;
                readonly="readonly";
          }
          tr+=`<tr class='edit-no-tb'>
                  <td>${index+1}</td>
                  <td>
                      <select class="form-control select2" name="type[]" onchange="select_type_commission_change(this)">
                        ${opt}
                      </select>
                  </td>
                  <td>
                      <input type="number" class="form-control" name="condition[]" 
                      placeholder="Amount ($)" required step="any" value="${value.commission_condition}" ${readonly}>
                  </td>
                  <td>
                      <input type="number" class="form-control" name="withdrawable[]" placeholder="Amount ($)" required step="any" value="${value.can_withdraw_condion}">
                  </td>
                  <td>
                      <button type="button" onclick="edit_remove(this)" class="btn btn-md btn-danger">
                          <i class="fas fa-trash"></i>
                      </button>
                  </td>
              </tr>`;
        });
        $("#edit-tb-condition-table").empty();
        $("#edit-tb-condition-table").append(tr);
        $("#edit-tb-condition-table").find("tr").first().find("td").last().find("button").attr("disabled",true);
        $(".select2").select2({
          theme: 'bootstrap4'
        });
      })
      .always(function() {
        console.log("complete");
      });
    
  }
  $(document).ready(function(){
    $("#datable-commission-condition").DataTable();
  });
  function edit_new_condition () {
    $("#edit-tb-condition-table").append(`
                      <tr class='edit-no-tb'>
                          <td>${$("#edit-tb-condition-table tr").length+1}</td>
                          <td>
                              <select class="form-control select2" name="type[]" onchange="select_type_commission_change(this)">
                                <option value="1">Booking&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                <option value="2">Monthly Payment</option>
                              </select>
                          </td>
                          <td>
                              <input type="number" class="form-control" name="condition[]" 
                              placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <input type="number" class="form-control" name="withdrawable[]" placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <button type="button" onclick="edit_remove(this)" class="btn btn-md btn-danger">
                                  <i class="fas fa-trash"></i>
                              </button>
                          </td>
                      </tr>`);
    $(".select2").select2({
      theme: 'bootstrap4'
    });
  }
  function new_condition () {
    $("#tb-condition-table").append(`
                      <tr class='no-tb'>
                          <td>${$("#tb-condition-table tr").length+1}</td>
                          <td>
                              <select class="form-control select2" name="type[]" onchange="select_type_commission_change(this)">
                                <option value="1">Booking&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                <option value="2">Monthly Payment</option>
                              </select>
                          </td>
                          <td>
                              <input type="number" class="form-control" name="condition[]" 
                              placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <input type="number" class="form-control" name="withdrawable[]" placeholder="Amount ($)" required step="any">
                          </td>
                          <td>
                              <button type="button" onclick="remove(this)" class="btn btn-md btn-danger">
                                  <i class="fas fa-trash"></i>
                              </button>
                          </td>
                      </tr>`);
    $(".select2").select2({
      theme: 'bootstrap4'
    });
  }
  function edit_remove(obj){
    $(obj).closest('tr').remove()
    var index= 1;
    $('.edit-no-tb').each(function() {
      $(this).find('td').first().text(index);
      index++;
    });
  }
  function remove(obj){
    $(obj).closest('tr').remove()
    var index=2;
    $('.no-tb').each(function() {
      $(this).find('td').first().text(index);
      index++;
    });
  }
</script>
@endsection