@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}}​ {{__("application.Role")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.User Management")}}</li>
              <li class="breadcrumb-item active">{{__("application.Role")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Role-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('roles.create') }}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table class="table table-bordered">
                <tr>
                   <th>No</th>
                   <th>Name</th>
                   <th width="280px">Action</th>
                </tr>
                  @foreach ($roles as $key => $role)
                  <tr>
                      <td>{{ ++$i }}</td>
                      <td>{{ $role->name }}</td>
                      <td>
                          <!-- <a class="btn btn-info" href="{{ route('roles.show',$role->id) }}">Show</a> -->

                          @can('Role-Edit')
                              <a class="btn btn-primary btn-sm" href="{{ route('roles.edit',$role->id) }}"><i class="fa fa-edit"></i></a>
                          @endcan
                          <!-- @can('role-delete')
                              {!! Form::open(['method' => 'DELETE','route' => ['roles.destroy', $role->id],'style'=>'display:inline']) !!}
                                  {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                              {!! Form::close() !!}
                          @endcan -->
                      </td>
                  </tr>
                  @endforeach
              </table>
              {!! $roles->render() !!}
              <br/>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
@endsection