@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}}​ {{__("application.Role")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.User Management")}}</li>
              <li class="breadcrumb-item"><a href="{{route('roles.index')}}">{{__("application.Role")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}}​ {{__("application.Role")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-body">
              {!! Form::model($role, ['method' => 'PATCH','route' => ['roles.update', $role->id]]) !!}
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Name:</strong>
                            {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Permission:</strong>
                            <br/>
                            @foreach($menu_name as $value_menu)
                              <div style="margin-left: 2%;">
                                <label>{{$value_menu->menu_name}} : <br/>
                                  <input style="margin-left: 20px;" type="checkbox" id="'Check-All-{{$value_menu->menu_name}}" name="permission_menu[]" class="{{$value_menu->menu_name}}" onchange='check_all(this)'>Check All</label>
                                <div style="margin-left: 3%;" class="row">
                                   @foreach($permission as $value)
                                        @if($value->menu_name==$value_menu->menu_name)
                                          <div class="col-sm-3">
                                            <label>{{ Form::checkbox('permission[]', $value->id, in_array($value->id, $rolePermissions) ? true : false, array('class' => $value_menu->menu_name)) }}
                                            {{ $value->name }}</label>
                                          </div>
                                        @endif
                                    @endforeach
                                </div>
                              </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
              <div style="text-align: right;">
                  <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                  <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
              </div>
            </div>
            {!! Form::close() !!}
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
  function check_all (obj) {
    var check_status = $(obj).prop("checked");
    var class_name = $(obj).attr("class");
    $("."+class_name).prop("checked",check_status);
  }
</script>
@endsection