@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Project")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item active">{{__("application.Project")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::model($project, ['method' => 'PATCH','route' => ['project.update', $project->id],'enctype' => 'multipart/form-data']) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Name")}}:</strong>
                                    {!! Form::text('name', null, array('placeholder' => __("application.Name"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.House")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('house_number', null, array('placeholder' => __("application.House")." ".__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.District")}}:</strong>
                                    @if(empty($project->get_district['district_id']))
                                    <select name="district" id="p_district" class="form-control select2">
                                        <option value="" selected>Please select</option>
                                    </select>
                                    @else
                                    <select name="district" id="p_district" class="form-control select2">
                                        <option value="{{$project->get_district['district_id']}}" selected>{{$project->get_district['district_id']}} {{$project->get_district['district_en']}} {{$project->get_district['district_km']}}</option>
                                    </select>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Village")}}:</strong>
                                    <select name="village" id="p_village" class="form-control select2">
                                        @if(empty($project->get_village['village_id']))
                                        <option value="" selected>Please select</option>
                                        @else
                                        <option value="{{$project->get_village['village_id']}}">{{$project->get_village['village_id']}} {{$project->get_village['village_en']}} {{$project->get_village['village_km']}}</option>
                                        @endif
                                    </select>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">

                                <div class="form-group">
                                    <strong>{{__("application.Street")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('street_number', null, array('placeholder' => __("application.Street")." ".__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Province")}}:</strong>
                                    {!! Form::select('province',$provinces,$project->province_id, array('class' => 'form-control select2','id'=>'p_province')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.Commune")}}:</strong>
                                    <select name="commune" id="p_commune" class="form-control select2">
                                        @if(empty($project->commune))
                                        <option value="" selected>Please select</option>
                                        @else
                                        <option value="{{$project->commune}}" selected>{{$project->get_commune['commune_id']}} {{$project->get_commune['commune_en']}} {{$project->get_commune['commune_km']}}</option>
                                        @endif
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}</strong>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'5')) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
@endsection