@extends("layouts.master")
@section("content")
<div class="modal fade" id="edit-raise-price">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Amount for Raising Price</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p style="font-size: 120%;"><input type="number" id="edit-raising-price" class="form-control"></p>
        <input type="hidden" id="edit-index-row">
      </div>
      <div class="modal-footer justify-content-between">
        <a>&nbsp;</a>
        <button type="button" class="btn btn-success btn-sm fa fa-save" data-dismiss="modal" onclick="save_edit_raise_price()"> Save</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="input-raise-price">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Amount for Raising Price</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p style="font-size: 120%;"><input type="number" id="amount-raising-price" class="form-control"></p>
      </div>
      <div class="modal-footer justify-content-between">
        <a>&nbsp;</a>
        <button type="button" class="btn btn-success btn-sm fa fa-save" data-dismiss="modal" onclick="save_raise_price()"> Save</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Price")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item"><a href="{{route("item.index")}}">{{__("application.Item")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Price")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
    {!! Form::open(array('route' => 'item.store_raise_price','method'=>'POST')) !!}
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-header border-transparent">
                        <h3 class="card-title"> {{__("application.Information")}} {{__("application.Of")}} {{__("application.Item")}}</h3>

                        <div class="card-tools">
                          <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                          </button>
                          <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                            <i class="fas fa-times"></i>
                          </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Project")}}:</strong>
                                    {!! Form::select('project',$projects,null, array('class' => 'form-control select2','required','id'=>'project-id')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Block")}}:</strong>
                                    <select name="block_id[]" class="form-controll select2" id="display-block" multiple> 
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                            </div>
                          <!-- /.col -->
                            <div class="col-md-12">
                                <button class="btn btn-sm btn-info" type="button" id="btn-raise-price" disabled>{{__("application.Edit")}} {{__("application.Price")}}</button>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                        </div>
                        
                        <table id="datable-item" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                  <th width="8%"> <label> Select All <input type="checkbox" id="select-all"></label></th>
                                  <th>{{__("application.No")}}</th>
                                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                                  <th>{{__("application.Cost")}}($)</th>
                                  <th>{{__("application.Price")}}($)</th>
                                  <th>{{__("application.Action")}}</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success" id="generate"> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    {!! Form::close() !!}
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
    $(document).on("change","#project-id",function () {
        var id = $(this).val();
        var route="{{route("item.get_item")}}";
        $('.main-spinner').show();
        $.ajax({
            url:route,
            dataType:'JSON',
            type:"POST",
            data:{
                "_token":"{{csrf_token()}}",
                "project_id":id
            },
            success:function(data){
                block_item = data;
                $('.main-spinner').hide();
                var opt=`<option value="">Please Select</option>`;
                $.each(data,function(index,val){
                    opt+=`<option value="${val.id}">${val.name}</option>`;
                });
                $("#display-block").empty();
                $("#display-block").append(opt);
            },
            error:function(){
                console.log("NO");
            }
        });
    });
    $(document).on("change","#display-block",function(){
        $(".main-spinner").show();
        $("#btn-raise-price").attr("disabled",true);
        var route = "{{route('get_item_by_zone',':id')}}";
        route = route.replace(':id',$(this).val()); 
        if($(this).val()=="") {$("#datable-item").find("tbody").empty();$(".main-spinner").hide();$("#btn-raise-price").attr("disabled",true);}
        $.ajax({
            url:route,
            type:"GET",
            dataType:"JSON",
            success:function(data){
                $(".main-spinner").hide();
                var tr=``;
                $.each(data,function(index,val){
                    tr += `<tr>
                              <td><input type="checkbox" class="select-raise-price"></td>
                              <td>${index+1}<input type="hidden" name="item_id[]" value="${val.id}" id="item-id-${index+1}"></td>
                              <td>${val.name}</td>
                              <td>${val.cost}($)</td>
                              <td>${val.price}($)<input type="hidden" name="item_price[]" value="${val.price}" id="item-price-${index+1}"></td>
                              <td><button class="btn btn-sm btn-primary" type="button" onclick="edit(this)"><i class="fa fa-edit"></i></button></td>
                            </tr>`;
                });
                $("#datable-item").find("tbody").empty();
                $("#datable-item").find("tbody").append(tr);
            },
            error:function(){

            }
        });
    });
    function edit(obj){
        $("#edit-index-row").val($(obj).closest('tr').find("td:eq(4)").find('input').attr('id'));
        $("#edit-raise-price").modal("show");
    }
    function save_edit_raise_price(){
        var amount = Number($("#edit-raising-price").val());
        var index_row = $("#edit-index-row").val();
        console.log(amount);
        if(amount==0){}
        else{
            $("#"+index_row).closest('tr').find("td:eq(4)").html(`${amount}($)<input type="hidden" name="item_price[]" value="${amount}" id="${index_row}">`);
        } 
    }
    function check_raise_price_selection(){
        var check_status = false;
        $(".select-raise-price").each(function(){
            if($(this).prop("checked")==true) check_status = true;
        });
        if(check_status==true) $("#btn-raise-price").removeAttr("disabled");
        else $("#btn-raise-price").attr("disabled",true);
    }
    $(document).on("change","#select-all",function(){
        var check_status = $(this).prop('checked');
        $(".select-raise-price").prop("checked",check_status);
        check_raise_price_selection();
    });
    $(document).on("change",".select-raise-price",function(){
        check_raise_price_selection();
    });
    $(document).on("click","#btn-raise-price",function(){
        $("#input-raise-price").modal("show");
    });
    function save_raise_price(){
        var amount = Number($("#amount-raising-price").val());
        if(amount==0 || isNaN(amount) || amount ==""){

        }else{
            $(".select-raise-price").each(function(){
                console.log($(this).prop("checked"));
                if($(this).prop("checked")==true){
                   var attr_id = $(this).closest("tr").find("td:eq(4)").find("input").attr("id");
                    $(this).closest("tr").find("td:eq(4)").empty();
                    $(this).closest("tr").find("td:eq(4)").append(`${amount}($)<input type="hidden" value="${amount}" name="item_price[]" id="${attr_id}">`);
                }
            });
        }
    }
</script>
@endsection