@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Item")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item active">{{__("application.Item")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Item-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('item.create') }}"> {{__("application.Create New")}}</a>
                <a class="btn btn-md btn-info" href="{{ route('item.raise_price') }}"> {{__("application.Edit")}} {{__("application.Price")}} {{__('application.By')}} {{__('application.Block')}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-item" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Block")}}</th>
                  <th>{{__("application.Cost")}}($)</th>
                  <th>{{__("application.Price")}}($)</th>
                  <th>{{__("application.Category")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Subcategory")}}</th>
                  <th>{{__("application.Project")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Group")}} {{__("application.Item")}}</th>
                  <th>{{__("application.Size")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  function delete_item(item_id){
    $.confirm({
        title:'Are you sure ?',
        content:'',
        theme:'modern',
        buttons:{
            cancel:{
                btnClass:'btn btn-primary',
                text:'Cancel',
                action:function () {

                }
            },
            submit:{
                btnClass:'btn btn-danger',
                text:"Delete",
                action:function () {
                        let route = '{{ route("item.delete",":id") }}';
                        route = route.replace(":id",item_id);
                        $.ajax({
                          url:route,
                          type:"GET",
                          dataType:"JSON",
                          success:function(data){
                            if($(`tbody tr#${item_id}`).hasClass("parent")){
                              $(`tbody tr#${item_id}`).next().remove();
                              $(`tbody tr#${item_id}`).remove();
                            }else{
                              $(`tbody tr#${item_id}`).remove();
                            }
                          },
                          error:function(){

                          }
                        });
                        // window.location.replace(route);
                }
            },
        },
    });
  }
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-item').DataTable({  
          "autoWidth": false,
          ordering: true,
          serverSide: true,
          "scrollY": screen.height,
          "scrollX": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          ajax: "{{ route('item.get_item') }}",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false,orderable: false},
              {data: 'name','name':'nso007_item_stock.name'},
              {data: 'block','searchable': false,orderable: false},
              {data: 'cost','name':'nso007_item_stock.cost'},
              {data: 'price','name':'nso007_item_stock.price'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'subcategory','searchable': false}, 
              {data: 'project_name','name':'nso007_project_stock.name'},  
              {data: 'groupitem','searchable': false},
              {data: 'size','name':'nso007_item_stock.size'},
              {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  
</script>
@endsection