@extends("layouts.master")
@section("content")
@include('installment.input_type_relationship')
@include('installment.edit-loan-installment')
<style>
.form-control:disabled, .form-control[readonly] {
    background-color: transparent;
    opacity: 1;
}
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" id="content-wrapper-id">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Installment")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item active"><a href="{{route('client-payment.index')}}">{{__("application.Client Payment")}}</a></li>
              <li class="breadcrumb-item active"><a href="#" onclick=" window.history.back();">{{__("application.Show")}} {{__("application.Detail")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Installment")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
    {!! Form::open(array('route' => 'installment.update','method'=>'POST')) !!}
      <div class="row">
        <div class="col-12">
    	<!-- card loan information -->
            <div class="card card-default">
              <!-- /.card-header -->
                <div class="card-header border-transparent">
                    <h2 class="card-title">{{__("application.Information")}} {{__("application.Of")}} {{__("application.Loan")}} </h2>

                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" name="loan_id" value="{{$loan_data->loan_id}}" required>
                                <strong class="required">{{__("application.Agency")}} {{__("application.Name")}}:</strong>
                                {!! Form::text('agency', $loan_data->agency_name, array('placeholder' => __("application.Agency")." ".__("application.Name"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                            
                            <div class="form-group">
                                <strong class="required">{{__("application.Item")}}:</strong>
                                {!! Form::text('item', $loan_data->item_name, array('placeholder' => __("application.Item"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                        <!-- /.form-group -->
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">{{__("application.Category")}}:</strong>
                                {!! Form::text('category', $loan_data->category_name, array('placeholder' => __("application.Category"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Project")}}:</strong>
                                {!! Form::text('project', $loan_data->project_name, array('placeholder' => __("application.Project"),'class' => 'form-control','required','readonly')) !!}
                            </div>
                        </div>
                      <!-- /.col -->
                      <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
              <!-- /.card-body -->
            </div>
        <!-- /.card -->
        <!-- card payment information step-->
            <div class="card card-default" id="payment-information-step">
              <!-- /.card-header -->
                <div class="card-header border-transparent">
                    <h3 class="card-title">{{__("application.Information")}} {{__("application.Of")}} {{__("application.Payment")}} </h3>

                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      <button type="button" class="btn btn-tool" disabled data-card-widget="remove">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong class="required">{{__("application.Amount")}} {{__("application.Sale")}}($):</strong>
                                {!! Form::number('sale_amount', $loan_data->sale_amount, array('placeholder' => 'Price','class' => 'form-control','required','id'=>'sale-amount','readonly','step'=>'any')) !!}
                            </div>
                            
                            
                            <div class="form-group">
                                <strong class="required">{{__("application.Amount")}} {{__("application.Deposit")}}($):</strong>
                                {!! Form::number('deposit_amount', $loan_data->sale_receive_amount, array('placeholder' => __("application.Amount")." ".__("application.Deposit"),'class' => 'form-control','required','id'=>'deposit-amount','readonly','step'=>'any')) !!}
                            </div>
                            <div class="form-group">
                                <strong class="required">{{__("application.Amount")}} {{__("application.Remain")}}($):</strong>
                                {!! Form::number('remain_amount', $loan_data->amount_os, array('placeholder' => __("application.Amount")." ".__("application.Remain"),'class' => 'form-control','required','id'=>'remain-amount-main','readonly','step'=>'any')) !!}
                            </div>
                        <!-- /.form-group -->
                        </div>
                      <!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong>{{__("application.Amount")}} {{__("application.Of")}} {{__("application.Discount")}}($):</strong>
                                {!! Form::number('discount_amount',$loan_data->discount_amount, array('placeholder' => __("application.Amount")." ".__("application.Of")." ".__("application.Discount"),'class' => 'form-control','id'=>'discount-amount',"step"=>"any",'readonly')) !!}
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Amount")}}​ {{__("application.Loan")}} {{__('application.Paid')}}</strong>
                                {!! Form::number('discount_percent', $loan_data->sale_amount-$loan_data->amount_os-$loan_data->discount_amount-$loan_data->sale_receive_amount, array('placeholder' => __("application.Percentage")." ".__("application.Percentage")." ".__("application.Discount"),'class' => 'form-control','required','id'=>'discount-percent',"step"=>"any",'readonly')) !!}
                            </div>
                            
                            <div class="form-group">
                                <strong class="required">{{__("application.Date")}} {{__("application.Of")}} {{__("application.Disburment")}}:</strong>
                                {!! Form::text('disburment_date', date("d-m-Y",strtotime($loan_data->diburment_date)), array('placeholder' => __("application.Date"),'class' => 'form-control date_picker','required','id'=>'disburment-date')) !!}
                            </div>
                        </div>
                        <div class="col-md-12">
                            &nbsp;
                        </div>
                      <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
              <!-- /.card-body -->
                <div class="card-footer">
                    <div style="text-align: right;">
                        <button type="button" class="btn btn-sm btn-default" title="Installment Step" style="background-color: #40A3AE;color:white;" id="installment-step">Step</button>
                        <button type="button" class="btn btn-sm btn-success" title="Installment Loan" id="installment-loan">Loan</button>
                        <!-- <button type="button" class="btn btn-sm btn-default" title="Installment Step with Loan" style="background-color: #6EB81C;color:white;" id="installment-step-loan">Step & Loan</button> -->
                    </div>
                </div>
            </div>
        <!-- /.card -->
            
        </div>
        <!-- /.col -->
      </div>
      <!-- TABLE: loan payment -->
      <div id="loan-payment-info"></div>
    <!-- /.card -->
      <!-- /.row -->
    {!! Form::close() !!}
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/reschedule/installment.js')}}"></script>
<script type="text/javascript" src="{{asset('assets/js/reschedule/installment-step.js')}}"></script>
<script type="text/javascript" src="{{asset('assets/js/reschedule/installment-loan.js')}}"></script>
<script>
    increment_z_index_datepicker();
    $(document).ready(function(){
        $("#list-client-relationship").hide();
        total_amount_input_step();
    });
    function type_save(){
    	var T = $("#relatioship-type").val();
    	var client_relationship = {!! json_encode($client_relationships->toArray()) !!};
    	if(T==""){
    		$("#relatioship-type").focus();
    		$("#relatioship-type").css("border","1px solid red");
    	}else{
    		var New_id=$("#client-relationship-selected").val();
            
    		$("#input-type-relationship").hide();
    		
    		if($("tbody#tb-list-client-relationship tr").length<=0){//First Append to tr(list client relationship)

    			//Find info for appending
    			const data=client_relationship.filter((d)=>{
	    			return d.id==New_id;
	    		});

	    		//Appending
                var tr=`<tr id="${data[0].id}">
                            <input type="hidden" name="client_relationship_id[]" value="${data[0].id}" required>
                            <td>${data[0].name}
                                <input type="hidden" name="client_relationship_name[]" value="${data[0].name}">
                            </td>
                            <td>${data[0].phone}
                                <input type="hidden" name="client_relationship_phone[]" value="${data[0].phone}"
                            </td>
                            <td>
                                <span class="badge badge-success">${T}
                                    <input type="hidden" name="client_relationship_type[]" value="${T}" required>
                                </span>
                            </td>
                        </tr>`;
	        	$("#list-client-relationship").show();
	        	$("tbody#tb-list-client-relationship").append(tr);
	        }
            else{//Secord to up Append to tr(list client relationship)
                var tr_id=[];
                //Push tr id to array
                $("#tb-list-client-relationship tr").each(function(){
                    tr_id.push($(this).attr("id"));

                });
                //Check id new selected option
                var app_id;
                for(var i=0;i<New_id.length;i++){
                    const app=tr_id.some((d)=>{
                        return d==New_id[i];
                    });
                    if(app==false){
                        app_id = New_id[i];
                    }
                    console.log(app);
                }

                console.log(app_id);
                
	        	// Find info data for appending
	        	const data=client_relationship.filter((d)=>{
	    			return d.id==app_id;
	    		});
	    		//End find

	    		//Appending
	        	var tr=`<tr id="${data[0].id}">
                            <input type="hidden" name="client_relationship_id[]" value="${data[0].id}" required>
	                        <td>${data[0].name}
                                <input type="hidden" name="client_relationship_name[]" value="${data[0].name}">
                            </td>
	                        <td>${data[0].phone}
                                <input type="hidden" name="client_relationship_phone[]" value="${data[0].phone}"
                            </td>
    	                   <td>
                                <span class="badge badge-success">${T}
                                    <input type="hidden" name="client_relationship_type[]" value="${T}" required>
                                </span>
                            </td>
	                </tr>`;
	        	$("tbody#tb-list-client-relationship").append(tr);
	        }
    	}
    }
    $(document).on("change","#client-relationship-selected",function(){

    	var id=$(this).val();
    	var tr = $("tbody#tb-list-client-relationship tr");

        if(tr.length<=0){
        	$("#input-type-relationship").show();
        	$("#relatioship-type").val("");
        }else{
        	//check tr and select
        	if(tr.length>id.length){ // remove tr
        		var tr_id=[];

        		//Push tr id to array
        		$("tbody#tb-list-client-relationship tr").each(function(){
        			tr_id.push($(this).attr("id"));
        		});

        		// Find tr for remove
        		$.each(tr_id,function(index,val){
        			const keep = id.some((d)=>{
        				return d == val;
        			});
        			if(keep==false){
        				$("tbody#tb-list-client-relationship tr#"+val).remove();
        			}
        		});
        	}else{
        		$("#input-type-relationship").show();
        		$("#relatioship-type").val("");
        	}
        	//select == null => remove tr
        	if(id.length<=0){
        		$("tbody#tb-list-client-relationship tr").remove();
                $("#list-client-relationship").hide();
        	}
        }
    });
    
</script>
@endsection