@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.workday')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.workday')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('hr-work-day.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{ __('administrator.code') }}</th>
                    <th>{{__('administrator.name')}}</th>
                    <th>{{ __('administrator.work') }}</th>
                    <th>{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('datatable.hr-get-workday') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'code'},
                        {data: 'name'},
                        {data: 'work'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                    $('#datatable_products tbody :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/full_day/g, '{{__('administrator.full_day')}}').replace(/half_day/g, '{{__('administrator.half_day')}}').replace(/day_off/g, '{{__('administrator.day_off')}}');
                    });
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
