@extends("layouts.master")
@section('content')
    <?php Fun::lang() ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.total_leave')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.total_leave')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Total Leave Generate'))
                                <a class="btn btn-sm btn-success" href="{{url('leave-total-generate')}}"><span class="fa fa-spinner"></span> {{__('administrator.generate')}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_total_leave" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Leave Year</th>
                                        <th>Employee</th>
                                        <th>Special Leave</th>
                                        <th>Sick Leave</th>
                                        <th>Maternity Leave</th>
                                        <th>Annual Leave</th>
                                        <th>Unpaid Leave</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script>
        $(function () {
            $('#datatable_total_leave').DataTable({
                ordering: false,
                processing: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: '{{ route("leave-total.index") }}',
                columns: [
                    {data: 'DT_RowIndex', searchable: false},
                    {data: 'leave_year'},
                    {data: 'employee', name: 'employee.english_name'},
                    {data: 'special_leave'},
                    {data: 'sick_leave'},
                    {data: 'maternity_leave'},
                    {data: 'annual_leave'},
                    {data: 'unpaid_leave'},
                    {data: 'action', searchable: false},
                ],
            });
        });
    </script>
@stop
