@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.total_leave')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.total_leave')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($data, ['method' => 'PATCH','route' => ['leave-total.update', $data->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                @php
                                    $emp = \App\User::find($data->emp_id);
                                @endphp
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.year')}}</label>
                                    {!! Form::text('leave_year', null, array('class' => 'form-control','disabled')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::text('emp_id', $emp->name, array('class' => 'form-control','disabled')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.special_leave')}}</label>
                                    {!! Form::text('special_leave', null, array('class' => 'form-control ')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.sick_leave')}}</label>
                                    {!! Form::text('sick_leave', null, array('class' => 'form-control ')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.maternity_leave')}}</label>
                                    {!! Form::text('maternity_leave', null, array('class' => 'form-control ')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.annual_leave')}}</label>
                                    {!! Form::text('annual_leave', null, array('class' => 'form-control ')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.unpaid_leave')}}</label>
                                    {!! Form::text('unpaid_leave', null, array('class' => 'form-control ')) !!}
                                    
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script>

    </script>
@endsection




