@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.edit")}} {{__("administrator.time_policy")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.time_policy")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($time_policy, ['method' => 'PATCH','route' => ['hr-time-policy.update', $time_policy->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <div class="">
                                                <strong class="required"  for="name">{{__('administrator.name')}}</strong>
                                                {!! Form::text('name', null, array('placeholder' => __('administrator.name'),'class' => 'form-control', 'autocomplete'=>'off','required')) !!}
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="">
                                                <strong class="" for="name">{{__('administrator.time_in')}}</strong>
                                                <!-- time Picker -->
                                                <div class="bootstrap-timepicker ">
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            {!! Form::text('time_in', null,array('class' => 'form-control timepicker')) !!}
                                                            <div class="input-group-addon">
                                                            <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="">
                                                <strong class="" for="name">{{__('administrator.time_out')}}</strong>
                                                <!-- time Picker -->
                                                <div class="bootstrap-timepicker ">
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            {!! Form::text('time_out', null,array('class' => 'form-control timepicker')) !!}
                                                            <div class="input-group-addon">
                                                            <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <div class="">
                                                <strong class="" for="name">{{__('administrator.ot_time_in')}}</strong>
                                                <!-- time Picker -->
                                                <div class="bootstrap-timepicker ">
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            {!! Form::text('ot_time_in', null,array('class' => 'form-control timepicker')) !!}
                                                            <div class="input-group-addon">
                                                            <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="">
                                                <strong class="" for="name">{{__('administrator.ot_time_out')}}</strong>
                                                <!-- time Picker -->
                                                <div class="bootstrap-timepicker ">
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            {!! Form::text('ot_time_out', null,array('class' => 'form-control timepicker')) !!}
                                                            <div class="input-group-addon">
                                                            <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="">
                                                <strong class=""  for="name">{{__('administrator.note')}}</strong>
                                                {!! Form::text('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control', 'autocomplete'=>'off')) !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection




