@if(count($payroll) > 0)
<div id="DivIdToPrint">
    <style>
        @page {
            size: auto;
            margin: 10px auto;
        }
        @media print {
            html, body {
                width: 210mm;
                height: 297mm;
                
            }
            .page-break{
                page-break-before: always;
            }
        }
        table {
            border-collapse: collapse;
        }

        table, th, td {
            
        }
        table thead th {
            border: none;
            text-align: center;
        }
        .container{
            width: 1024px;
            margin: 0 auto;
            
        }
        .battambong
        {
            font-family: khmer os battambang !important;
            font-size: 12px;
        }
        .arial
        {
            font-family: Arial, Helvetica, sans-serif, khmer os battambang !important;
            font-size: 12px;
        }
        .w-100
        {
            width:100%;
        }
        .w-60
        {
            width:60%;
            float:left;
        }
        .w-40
        {
            width:40%;
            float: right;
        }
    </style>
    <div class="container">
        @foreach($payroll as $row)
            @if($row != "")
                @php 
                    $gross_pay      = 0;
                    $total_ot       = 0;
                    $total_benefit  = 0;
                                    
                    $year           = $row->year;
                    $month          = $row->month;
                    
                    $benefit        = App\Models\Hr\HrEmployeeBenefitModel::where('emp_id', $row->emp_id)->get();
                    $ot             = App\Models\Hr\HrOvertimeRequestModel::where('emp_id',$row->emp_id)->where('status',1)->get();
                    $date           = $row->f_year.'-'.$row->f_month.'-'.'01';
                    $em             = App\User::find($row->emp_id);

                @endphp
                
                <table style="" class="arial w-100">
                    <thead>
                        <tr>
                            <th colspan="7" style="text-align:center"><span style="font-family:Khmer OS muol light">អិនអេសអូ ភីអិលសុី</span><br>NSO PLC.</th>
                        </tr>
                        <tr style="border-bottom: 1px solid black !important;"> 
                            <th style="text-align:center">Employee Payroll slip</span><br><span class="battambong"> ក្រដាស់បើកប្រាក់ខែ </span></th>
                            <th colspan="5"></th>
                            
                            <th style="text-align:center">For The Month of: {{App\Helpers\IDate::getMonthName($date)}} {{$row->f_year}} <br><span class="battambong">សម្រាប់ខែ: {{App\Helpers\IDate::getMonthNameKH($date)}} {{$row->f_year}}​  </span></th>  
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>លេខរៀង</td>
                            <td>Number</td>
                            <td colspan="2">{{$row->id}}</td>
                            <td>អត្តលេខ</td>
                            <td>Employee No</td>
                            <td>{{optional($row->employee)->user_code}}</td>
                        </tr>
                        <tr>
                            <td>ផ្នែក</td>
                            <td>Dept</td>
                            <td colspan="2"></td>
                            <td>ឈ្មោះអង់គ្លេស</td>
                            <td>English Name</td>
                            <td>{{optional($row->employee)->english_name}}</td>
                        </tr>
                        <tr>
                            <td>មុខងារ</td>
                            <td>Position</td>
                            <td colspan="2"></td>
                            <td>ឈ្មោះជាភាសារខ្មែរ</td>
                            <td>Khmer Name</td>
                            <td>{{optional($row->employee)->khmer_name}}</td>
                        </tr>
                        <tr>
                            <td>ថ្ងៃ</td>
                            <td>Day=$ {{optional($row->employee)->basic_salary}} / 26 / 8x</td>
                            <td colspan="2">26</td>
                            <td>ថ្ងៃចូលធ្វើការ</td>
                            <td>Joined Date</td>
                            <td>{{date('d-m-Y', strtotime(optional($row->employee)->joined_date))}}</td>
                        </tr>
                        <tr>
                            <td>មូលដ្ឋានប្រាក់ខែ</td>
                            <td>Basic Pay</td>
                            <td colspan="2">$ {{optional($row->employee)->basic_salary}}</td>
                            <td>ប្រាក់ឈ្នួលប្រចាំខែ</td>
                            <td>Basic</td>
                            <td>$ {{optional($row->employee)->basic_salary}}</td>
                        </tr>
                    </tbody>
                </table>                    
                <table style="" class="arial w-60">
                    <thead>
                        <tr style="border-bottom: 1px solid !important; border-top: 1px solid !important;">
                            <th style="text-align:left">បូកបន្ថែម</th>
                            <th style="text-align:left">Add(+)</th>
                            <th>ថ្ងៃ</th>
                            <th>Day(s)</th>
                            <th>ប្រាក់</th>
                            <th>Amt</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>ប្រាក់ឈប់ប្រចាំឆ្នាំ</td>
                            <td>Annual Leave Taken</td>
                            <td></td>
                            <td style="text-align: center;">0</td>
                            <td></td>
                            <td>$0.00</td>
                            
                        </tr>
                        <tr>
                            <td>សំរាកមានប្រាក់ឈ្នួល</td>
                            <td>Take Leave</td>
                            <td></td>
                            <td style="text-align: center;">0</td>
                            <td></td>
                            <td>$0.00</td>
                            
                        </tr>
                        <tr>
                            <td>ប្រាក់រង្វាន់ វត្តមាន</td>
                            <td>Attendance Bonus</td>
                            <td></td>
                            <td style="text-align: center;">0</td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់អតីតភាព</td>
                            <td>Seniority Bonus</td>
                            <td></td>
                            <td style="text-align: right;"></td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់សុខភាព</td>
                            <td>Health Care</td>
                            <td></td>
                            <td style="text-align: right;"></td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់ធ្វើដំណើរ</td>
                            <td>Transport Pay</td>
                            <td></td>
                            <td style="text-align: right;"></td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់រង្វាន់បុង</td>
                            <td>Piece Incentive</td>
                            <td></td>
                            <td style="text-align: right;"></td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>ផ្សេងៗ</td>
                            <td>Other</td>
                            <td></td>
                            <td style="text-align: right;"></td>
                            <td></td>
                            <td>$0.00</td>
                        </tr>
                        @foreach ($benefit as $item)
                            <tr>
                                <td>{{optional($item->get_benefit)->name_kh}}</td>
                                <td>{{optional($item->get_benefit)->name}}</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="text-align:center;">$ {{number_format($item->amount,2)}}</td>
                                
                            </tr>
                            @php
                                $total_benefit += $item->amount;
                            @endphp
                        @endforeach
                        {{-- overtime --}}
                        <tr style="border-bottom: 1px solid !important; border-top: 1px solid !important;">
                            <th style="text-align:left">ថែមម៉ោង</th>
                            <th style="text-align:left">Overtime</th>
                            <th>ម៉ោង</th>
                            <th>hr(s)</th>
                            <th>ប្រាក់</th>
                            <th>Amt</th>
                        </tr>
                        <tr>
                            <td>ប្រាក់ថែមម៉ោងថ្ងៃធម្មតា</td>
                            <td>OT Normal</td>
                            <td></td>
                            <td style="text-align:center;">0</td>
                            <td></td>
                            <td>$ 0.00</td> 
                        </tr>
                        <tr>
                            <td>ប្រាក់ថ្ងៃអាទិត្យ</td>
                            <td>OT Sunday</td>
                            <td></td>
                            <td style="text-align:center;">0</td>
                            <td></td>
                            <td>$ 0.00</td> 
                        </tr>
                        <tr>
                            <td>ប្រាក់ថ្ងៃឈប់សម្រាក​ ឫ​ ថ្ងៃបុណ្យ</td>
                            <td>OT Holiday</td>
                            <td></td>
                            <td style="text-align:center;">0</td>
                            <td></td>
                            <td>$ 0.00</td> 
                        </tr>
                        @php
                            $total_ot += 1 * 5;
                        @endphp
                        
                        
                        <tr style="border-top: 1px solid !important;">
                            <td><b>ប្រាក់សរុប</b></td>
                            <td><b>Gross Pay</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td style="text-align:center;">${{number_format($gross_pay = $total_ot + $total_benefit, 2)}}</td>
                            
                        </tr>
                    </tbody>
                </table>
                <table style="margin-bottom: 50px;" class="arial w-40">
                    <thead>
                        <tr style="border-bottom: 1px solid !important; border-top: 1px solid !important;">
                            <th style="text-align:left">ប្រាក់កាត់ចេញ</th>
                            <th style="text-align:left">Deduction (-)</th>
                            <th>ប្រាក់</th>
                            <th>Amt</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>វិភាជន៍លើគ្រួសារ</td>
                            <td>Family Allowance</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់ពន្ធលើប្រាក់បៀរវត្ស</td>
                            <td>Salary Tax</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់សមាជិក</td>
                            <td>Union Member Fee</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាកខ្ចី</td>
                            <td>Loan</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាកពិសេសបើកមុន</td>
                            <td>Advance Salary</td>
                            <td></td>
                            <td style="text-align: right;">$ {{$row->advance_salary ? number_format($row->advance_salary, 2) : 0}}</td>
                        </tr>
                        <tr>
                            <td>បសស</td>
                            <td>NSSF</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ផ្សេងៗ</td>
                            <td>Other</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr style="border-top: 1px dotted !important;">
                            <td><b>សរុបប្រាក់កាត់</b></td>
                            <td><b>Total Deduction</b></td>
                            <td></td>
                            <td style="text-align: right;"></td>
                        </tr>
                        <tr style="border-top: 1px dotted !important;">
                            <td>លុយបាយប្រចាំខែ</td>
                            <td>Meal Allowance</td>
                            <td></td>
                            <td style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់ត្រូវបើក (ដុល្លា)</td>
                            <td>Net Pay (USD)</td>
                            <td></td>
                            <td style="text-align: right;">$ {{number_format($row->net_pay, 2)}}</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់ត្រូវបើក​ (ខ្មែរ)</td>
                            <td>Net Pay (Riel)</td>
                            <td></td>
                            <td style="text-align: right;">៛ {{number_format($row->net_pay_kh, 2)}}</td>
                        </tr>
                        <tr>
                            <td>ប្រាក់ត្រូវបើក​ (ថៃ)</td>
                            <td>Net Pay (Baht)</td>
                            <td></td>
                            <td style="text-align: right;">฿ {{number_format($row->net_pay_th, 2)}}</td>
                        </tr>
                        <tr style="border-top: 1px dotted !important;">
                            <td>បានទទួលដោយ</td>
                            <td></td>
                            <td rowspan="2">ស្នាមមេដៃសាមីខ្លួន</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Received By</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
                <div class="page-break">
                </div>
            @endif
        @endforeach
    </div>
</div>
@else
    <h1>No data!!</h1>
@endif