@extends('layouts.app-hr')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.report')}}</a></li>
            <li class="active">{{__('administrator.payroll')}}</li>
        </ol>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="col-sm-12 col-xs-12">
        <form action="" method="POST">
            @csrf
            <div class="row">
                <div class="col-xs-4 col-sm-4 col-md-4">
                    <div class="form-group">
                        <strong>Type:</strong>
                        <select class="form-control" id="select">
                            <option value="default" selected>Select</option>
                            <option value="{{route('report.payroll')}}">List Payroll</option>
                            <option value="{{route('report.payslip')}}">Payslip</option>
                        </select>
                    </div>
                </div>
                <div class="col-xs-8 col-sm-8 col-md-8">
                    <div class="form-group">
                        <strong>Employee:</strong>
                        @php
                            $emp = App\User::pluck('name', 'id');
                        @endphp
                        {!! Form::select('employee[]',$emp,null, array('class' => 'form-control', 'multiple'=>'multiple', 'autocomplete' => 'off','' )) !!}
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4">
                    <div class="form-group">
                        <strong>Month:</strong>
                        {!! Form::text('month',null, array('placeholder'=>__('administrator.month'),'class' => 'form-control  month_year', 'autocomplete' => 'off','' )) !!}
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4">
                    <div class="form-group">
                        <strong>From Date:</strong>
                        {!! Form::text('from_date',null, array('placeholder'=>__('administrator.from_date'),'class' => 'form-control  date_picker', 'autocomplete' => 'off','' )) !!}
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4">
                    <div class="form-group">
                        <strong>To Date:</strong>
                        {!! Form::text('to_date',null, array('placeholder'=>__('administrator.to_date'),'class' => 'form-control  date_picker', 'autocomplete' => 'off','' )) !!}                    </div>
                </div>
                
                @include('hr.report-hr.main-script')

            </div>

            
        </form>
    </div>
@endsection