@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    @php
        $from_date      = @$_GET['from_date'];
        $to_date        = @$_GET['to_date'];
        $emp_id         = @$_GET['emp_id'];
        $branch_id      = @$_GET['branch_id'];
        $department_id  = @$_GET['department_id'];
        $position_id    = @$_GET['position_id'];
    @endphp
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.report_benefit')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group paddin-0">
                        <div>
                            {!! Form::open(array('route' => 'get-report-employee','method'=>'get')) !!}
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        @php
                                            $user = App\User::pluck('name', 'id')->prepend(__('administrator.please_select'),'');
                                        @endphp
                                        <strong for="">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp_id',$user , ['class' => 'form-control emp_id', 'id' => 'emp_id','autocomplete' => 'off']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        @php
                                            $branch = App\Model\Hr\HrBranch::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
                                        @endphp
                                        <strong for="">{{__('administrator.branch')}}</strong>
                                        {!! Form::select('branch_id', $branch, array('class' => 'form-control','autocomplete' => 'off')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        @php
                                            $department = App\Model\Hr\HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
                                        @endphp
                                        <strong for="">{{__('administrator.department')}}</strong>
                                        {!! Form::select('department_id', $department, array('class' => 'form-control select2','autocomplete' => 'off')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        @php
                                            $position = App\Model\Hr\HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
                                        @endphp
                                        <strong for="">{{__('administrator.position')}}</strong>
                                        {!! Form::select('position_id', $position, array('class' => 'form-control select2','autocomplete' => 'off')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for="">{{__('administrator.from_date')}}</strong>
                                        {!! Form::text('from_date', $from_date, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker', 'id' => 'from_date','autocomplete' => 'off','')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for="">{{__('administrator.to_date')}}</strong>
                                        {!! Form::text('to_date', $to_date, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker', 'id' => 'to_date','autocomplete' => 'off','')) !!}
                                    </div>
                                </div>
                                <div class=" col-sm-12">
                                    {{-- {!! Form::open(array('route' => 'reportsales_print','method'=>'GET')) !!}
                                    <button class=" button_success pull-right print_button" type="button" ><i class="fa fa-print "></i> {{__('administrator.print')}}</button>
                                    {!! Form::close() !!} --}}
                                    <button class=" button_primary pull-right" type="button" onclick="search()"> {{__('administrator.search')}}</button>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="table_benefit" width="100%" class="table table-striped table-hover ">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('administrator.employee')}}</th>
                            <th>{{__('administrator.benefit')}}</th>

                        </tr>
                    </thead>
                    <tbody class="tbody">

                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#table_benefit').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "{{ route('get-report-benefit') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'emp_id', 'searchable': false},
                        {data: 'benefit_id', 'searchable': false},
                    ],
                "scrollX": true
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
        function search(){
            var emp_id          = $('select[name="emp_id"]').find(':selected').val();
            var branch_id       = $('select[name="branch_id"]').find(':selected').val();
            var department_id   = $('select[name="department_id"]').find(':selected').val();
            var position_id     = $('select[name="position_id"]').find(':selected').val();
            var from_date       = $('#from_date').val();
            var to_date         = $('#to_date').val();

            $('#table_benefit').DataTable().destroy();
            $('#table_benefit').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: {
                    url:"{{ route('get-report-benefit') }}",
                    type:'POST',
                    data:{
                        _token:"{{csrf_token()}}",
                        emp_id:emp_id,
                        branch_id: branch_id,
                        department_id: department_id,
                        position_id: position_id,
                        from_date: from_date,
                        to_date: to_date
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'emp_id', 'searchable': false},
                        {data: 'benefit_id', 'searchable': false},

                    ],
                "scrollX": true
            });
            $.fn.dataTable.ext.errMode = 'throw';
        }
    </script>
@stop




