@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.position.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.position")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.position")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Position Create')
                                    <a class="btn btn-sm btn-success" href="{{route('hr-position.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_position" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.code') }}</th>
                                        <th>{{__('administrator.khmer_name')}}</th>
                                        <th>{{__('administrator.english_name')}}</th>
                                        <th style="width: 200px">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete_position', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_position').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-position') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'code'},
                        {data: 'khmer_name'},
                        {data: 'english_name'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
