@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.overtime-type.confirm-delete')
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.overtime_type')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.overtime_type')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('overtime-type.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_overtime_type" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.en_name')}}</th>
                    <th>{{__('administrator.kh_name')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{ __('administrator.note') }}</th>
                    <th style="width: 200px;">{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_overtime_type').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('overtime-type.index') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'en_name'},
                        {data: 'kh_name'},
                        {data: 'date'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                   
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
