@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.leave')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.leave_list')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('hr-leave-request.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{ __('administrator.employee') }}</th>
                    <th>{{__('administrator.leave_type')}}</th>
                    <th>{{__('administrator.from_date')}}</th>
                    <th>{{__('administrator.to_date')}}</th>
                    <th>{{__('administrator.status')}}</th>
                    <th>{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h3 class="modal-title">{{ __('administrator.are_you_sure')}}</h3>
                </div>
                <br/>
                <form role="form" method="POST" id="form_update">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-12">
                                <input type="hidden" name="id" id="id">
                            </div>
                            <div class="form-group col-sm-12 col-xs-12">
                                <label class="required">{{ __('administrator.status')}}</label>
                                <select name="status" class="form-control input-lg" required>
                                    <option value="">{{ __('administrator.please_select')}}</option>
                                    <option value="1">{{ __('administrator.approve')}}
                                    </option>
                                    <option value="2">{{ __('administrator.reject')}}
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                    class="fa fa-close"></i> {{ __('administrator.close')}}
                        </button>
                        <button type="submit" class="btn btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> {{ __('administrator.save')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h3 class="modal-title">{{ __('administrator.info_detail') }} </h3>
                </div>
                <br/>
                <div class="row" style="line-height: 30px">
                    <div class="col-md-12">
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.employee') }}</div>
                            <div class="col-sm-7 col-xs-12 emp"></div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.leave_type') }}</div>
                            <div class="col-sm-7 col-xs-12 type"></div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.from_date') }}</div>
                            <div class="col-sm-7 col-xs-12 fdate"></div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.to_date') }}</div>
                            <div class="col-sm-7 col-xs-12 tdate"></div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.info_detail') }}</div>

                            <div class="col-sm-7 col-xs-12 detail">

                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.reason') }}</div>
                            <div class="col-sm-7 col-xs-12 reason"></div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="col-sm-2 col-xs-12"></div>
                            <div class="col-sm-3 col-xs-12">{{ __('administrator.status') }}</div>
                            <div class="form-group col-sm-7 col-xs-12 status"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i class="fa fa-close"></i> {{ __('administrator.close') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                var url = "{{route('hr.leave-change-status')}}";
                $('#form_update').attr('action', url + '?id=' + id);
                $('#myModal').modal('show');
            });
            $(document).on('click', '.viewLeave', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "{{route('leave.view')}}",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.emp').text(data.datas.employee);
                        $('.type').text(data.datas.leave_type);
                        $('.fdate').text(data.datas.from_date);
                        $('.tdate').text(data.datas.to_date);
                        $('.reason').text(data.datas.reason);
                        $('.status').html(data.datas.status);
                        var arr = data.datas.detail;
                        var st = '';
                        var label = '';
                        for(i = 0;i<arr.length;i++){
                            if(arr[i].type == 'full_day'){
                                label = ' <span class="label label-success">{{ __('administrator.full_day') }}</span>';
                            }
                            if(arr[i].type == 'half_day'){
                                label = ' <span class="label label-warning">{{ __('administrator.half_day') }}</span>';
                            }
                            if(arr[i].type == 'day_off'){
                                label = ' <span class="label label-danger">{{ __('administrator.day_off') }}</span>';
                            }
                            st += '<div class="col-sm-12 col-xs-12">'+
                                arr[i].code+' '+arr[i].date+' '+label+
                                '</div>';
                        }
                        $('.detail').html(st);
                        $('body :not(script)').contents().filter(function () {
                            return this.nodeType === 3;
                        }).replaceWith(function () {
                            return this.nodeValue.replace(/1/g, '{{__('administrator.1')}}').replace(/2/g, '{{__('administrator.2')}}').replace(/3/g, '{{__('administrator.3')}}').replace(/4/g, '{{__('administrator.4')}}').replace(/5/g, '{{__('administrator.5')}}').replace(/6/g, '{{__('administrator.6')}}').replace(/7/g, '{{__('administrator.7')}}').replace(/8/g, '{{__('administrator.8')}}').replace(/9/g, '{{__('administrator.9')}}').replace(/0/g, '{{__('administrator.0')}}');
                        });
                    }
                });
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('datatable.hr-get-leave') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'emp_id'},
                        {data: 'leave_type'},
                        {data: 'from_date'},
                        {data: 'to_date'},
                        {data: 'status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
