@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.job-benefit.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.benefit_type")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.benefit_type")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Benefit Type Create'))

                                <a class="btn btn-sm btn-success" href="{{route('hr-job-benefit.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.en_name')}}</th>
                                        <th>{{__('administrator.kh_name')}}</th>
                                        <th>{{__('administrator.amount')}}</th>
                                        <th>{{ __('administrator.note') }}</th>
                                        <th style="width: 200px;">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_job_benefit', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-job-benefit') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'name'},
                        {data: 'name_kh'},
                        {data: 'amount'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],

                "initComplete": function (settings, json) {
                    $('#datatable_products tbody :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/full_day/g, '{{__('administrator.full_day')}}').replace(/half_day/g, '{{__('administrator.half_day')}}').replace(/day_off/g, '{{__('administrator.day_off')}}');
                    });
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
