@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.in_external_training")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.in_external_training')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('In-External Training Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-in-external-training.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee')}}</th>
                                        <th>{{__('administrator.training_course')}}</th>
                                        <th>{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-in-ex-training') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'training_course_id'},
                        {data: 'action', searchable: false},
                    ],
                    "initComplete": function (settings, json) {

                }
            });

            $.fn.dataTable.ext.errMode = 'throw';

        });
    </script>
@endsection
