@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <h3>{{__('administrator.create_role')}}</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-wrapper">
                        {!! Form::open(array('route' => 'hr-roles.store','method'=>'POST','id'=>'form_validate')) !!}
                        <div class="form-group col-sm-4 col-xs-12">
                            <label class="required" for="name"> <h3>{{__('administrator.title')}}</h3></label>
                            {!! Form::text('name', null, array('placeholder' => 'Title','class' => 'form-control','required')) !!}
                            <span class="focus-border"></span>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <strong>{{__('administrator.permission')}} <span class="required">*</span></strong>
                        </div>
                        <div class="col-sm-12">
                            <div class="vertical-tabs">
                                <ul class="nav nav-tabs" role="tablist">
                                    @foreach($group_app_name as $key=>$row)
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#pag{{$key}}" role="tab"
                                               aria-controls="home">{{$row->group_name}}</a>
                                        </li>
                                    @endforeach

                                </ul>

                                <div class="tab-content">
                                    @foreach($group_app_name as $key=>$row)
                                        <div class="tab-pane {{$key==0?'active':''}}" id="pag{{$key}}" role="tabpanel">
                                            <div class="sv-tab-panel hr-height">
                                                @php
                                                    $items = \Spatie\Permission\Models\Permission::where('group_name',$row->group_name)->get();
                                                    $string = preg_replace('/\s+/', '', $row->group_name);
                                                @endphp
                                                <div class="col-sm-12">{{ Form::checkbox('check_all[]',$string, false, array('class' => ' check_all')) }}
                                                    {{__('administrator.check_all')}}
                                                </div>
                                                @php
                                                    $permission = \Spatie\Permission\Models\Permission::where('group_name',$row->group_name)->get();
                                                @endphp
                                                @foreach($permission as $value)
                                                    <div class="col-sm-3">
                                                        {{ Form::checkbox('permission[]', $value->id, false, array('class' =>$string)) }}
                                                        {{ $value->name }}
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <button type="submit" class=" button_primary pull-right"><span
                                            class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="history.go(-1)" class=" button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script>
        $(".check_all").change(function() {
            let this_ = $(this);
            let check = $(this).prop("checked");
            let val = '';
            if(check){
                val = '.'+this_.val();
            }
            console.log(val);
            $(val+`:checkbox`).prop('checked', check);
        });

    </script>

@endsection
