@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.holiday.confirm-delete')
    @include('hr.holiday.import-excel')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.holiday")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.holiday")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Holiday Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-holiday.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_holiday" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.holiday')}}</th>
                                        <th>{{__('administrator.from_date')}}</th>
                                        <th>{{__('administrator.to_date')}}</th>
                                        <th>{{__('administrator.year')}}</th>
                                        <th>{{__('administrator.note')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn_del_holiday', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_holiday').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{route('hr.get-holiday')}}",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'name_en'},
                        {data: 'from_date'},
                        {data: 'to_date'},
                        {data: 'year'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
