<link href="https://fonts.googleapis.com/css?family=Content|Moul|Titillium+Web" rel="stylesheet">
<style>

    @media print {

        .container {
            width: 821px !important;
            font-size: 16px !important;
            box-shadow: none !important;
        }

        .table-responsive-ss table tr, .table-responsive-ss td {
            font-size: 16px !important;
        }

        p, span, b {
            font-size: 16px !important;
        }

        .table-responsive-ss * {
            -webkit-print-color-adjust: exact;
        }

        .table-responsive-ss table {
            width: 100%;
            margin-top: 1px !important;
            padding-top: -21px !important;
            font-family: "Times New Roman" !important;
        }

        .table-responsive-ss th {
            white-space: nowrap;
        }

        .table-responsive-ss tr th {

            vertical-align: middle !important;
            color: white !important;
            /* background-color: #112EB0 !important; */
        }

    }

    .table-responsive-ss table {
        width: 100%;
        margin-top: 1px !important;
        padding-top: -21px !important;
    }

    .table-responsive-ss th {
        white-space: nowrap;
    }

    .table-responsive-ss tr th {

        vertical-align: middle !important;
        color: white !important;
        font-size: 12px !important;
        /* background-color: #112EB0 !important; */
        font-family: "Times New Roman" !important;
    }

</style>

@if($emp != null)
    <section class="content">
        <div class="table-responsive table-responsive-ss">
            <table class="table table-bordered" border="1" style="width: 100%;border-collapse: collapse;">
                <thead>
                    <tr>
                        <th style="text-align: center;"><input class="ch-em-id-all" type="checkbox"></th>
                        <th style="text-align: center;">Name</th>
                        <th style="text-align: center;">Basic Salary</th>
                        <th style="text-align: center;">Benefit</th>
                        <th style="text-align: center;">OT</th>
                        <th style="text-align: center;">Transport Allowance</th>
                        <th style="text-align: center;">Meal Allowance</th>
                        <th style="text-align: center;">Spouse</th>
                        <th style="text-align: center;">Child</th>
                        <th style="text-align: center;">Deduction</th>
                        <th style="text-align: center;">Income Tax</th>
                        <th style="text-align: center;">Gross Pay</th>
                        <th style="text-align: center;">Taxable Salary</th>
                        <th style="text-align: center;">Net Payment</th>

                    </tr>
                </thead>

                <tbody>
                    @foreach($emp as $row)
                        <tr>
                            @php

                                $f_date = explode('-', $from_date);
                                $f_date = $f_date[2].'-'.$f_date[1].'-'.$f_date[0];
                                $t_date = explode('-', $to_date);
                                $t_date = $t_date[2].'-'.$t_date[1].'-'.$t_date[0];

                                //get benefit
                                $benefit                = App\Helpers\GenSalaryNoFp::getBenefit($row->id);
                                $benefit                = $benefit['emp_benefit']?$benefit['emp_benefit']:0;
                                //get overtime
                                $ot                     = App\Helpers\GenSalaryNoFp::getOT($f_date, $t_date, $row);
                                $ot                     = $ot['total_ot']?$ot['total_ot']:0;
                                //get tax rate
                                $income_tax_rate        = App\Helpers\GenSalaryNoFp::getIncomeTaxRate($row->basic_salary);
                                $income_tax_deduction   = App\Helpers\GenSalaryNoFp::getIncomeTaxDeduction($row->basic_salary);
                                // grosspay
                                $gross_pay              = App\Helpers\GenSalaryNoFp::getGrossPay($row,$ot,$benefit,$row->basic_salary);
                                $gross_pay              = $gross_pay['gross_pay']?$gross_pay['gross_pay']:0;

                                $income_tax             = App\Helpers\GenSalaryNoFp::getIncomeTax($row, $gross_pay);

                                $taxable_salary         = $income_tax['taxable_salary']?$income_tax['taxable_salary']:0;
                                $income_tax             = $income_tax['income_tax']?$income_tax['income_tax']:0;
                                $net_pay                = $gross_pay - $income_tax;
                                $net_pay                = $net_pay > 0 ? $net_pay : 0;

                                $exchange_rate          = App\Helpers\GenSalaryNoFp::getNormalExRate();

                                $adv = App\Helpers\GenSalaryFp::getGenerateSalary($row->id, $f_date, $t_date);
                                dd($adv)
                                
                            @endphp
                            <td>

                                <input class="ch-em-id" name="emp_id_ch[{{$row->id}}]" type="checkbox"value="{{$row->id}}">
                                <input type="hidden" name="basic_salary[{{$row->id}}]" value="{{$row->basic_salary}}">
                                <input type="hidden" name="income_tax_rate[{{$row->id}}]" value="{{$income_tax_rate}}">
                                <input type="hidden" name="income_tax[{{$row->id}}]" value="{{$income_tax}}">
                                <input type="hidden" name="spouse[{{$row->id}}]" value="{{$row->spouse}}">
                                <input type="hidden" name="child[{{$row->id}}]" value="{{$row->child}}">
                                <input type="hidden" name="benefit[{{$row->id}}]" value="{{$benefit}}">
                                <input type="hidden" name="ot[{{$row->id}}]" value="{{$ot}}">

                                <input type="hidden" name="meal_allowance[{{$row->id}}]" value="{{$row->meal_transport_allowance / 2}}">
                                <input type="hidden" name="transport_allowance[{{$row->id}}]" value="{{$row->meal_transport_allowance / 2}}">
                                <input type="hidden" name="exchange_rate[{{$row->id}}]" value="{{$exchange_rate}}">

                                <input type="hidden" name="gross_pay[{{$row->id}}]" value="{{number_format($gross_pay, 2)}}">
                                <input type="hidden" name="net_pay[{{$row->id}}]" value="{{number_format($net_pay, 2)}}">
                                <input type="hidden" name="taxable_salary[{{$row->id}}]" value="{{number_format($taxable_salary, 2)}}">

                            </td>
                            <td style="text-align: center">{{$row->name}}</td>
                            <td style="text-align: center">{{$row->basic_salary}}</td>
                            <td style="text-align: center">{{$benefit?$benefit:0}}</td>
                            <td style="text-align: center">{{$ot?$ot:0}}</td>
                            <td style="text-align: center">{{$row->meal_transport_allowance / 2}}</td>
                            <td style="text-align: center">{{$row->meal_transport_allowance / 2}}</td>
                            <td style="text-align: center">{{$row->spouse}}</td>
                            <td style="text-align: center">{{$row->child}}</td>
                            <td style="text-align: center">0</td>
                            <td style="text-align: center">{{$income_tax}}</td>
                            <td style="text-align: center">{{number_format($gross_pay, 2)}}</td>
                            <td style="text-align: center">{{number_format($taxable_salary, 2)}}</td>
                            <td style="text-align: center">{{number_format($net_pay, 2)}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</div>
@else
    <h1>No data to generate!!</h1>
@endif
