@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.generate-salary')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.generate-salary')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-generate-salary.store','method'=>'POST')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong>{{__('administrator.branch')}}:</strong>
                                        {!! Form::select('branch_id[]',$branch,null, array('class' => 'form-control select2', 'multiple'=>'multiple', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong>{{__('administrator.department')}}:</strong>
                                        {!! Form::select('department_id[]',$department,null, array('class' => 'form-control select2','multiple'=>'multiple', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong>{{__('administrator.position')}}:</strong>
                                        {!! Form::select('position_id[]',$position,null, array('class' => 'form-control select2','multiple'=>'multiple', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>{{__('administrator.employee')}}:</strong>
                                        {!! Form::select('emp_id[]',$emp,null, array('class' => 'form-control select2', 'multiple'=>'multiple', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong class="required">{{__('administrator.month')}}:</strong>
                                        {!! Form::text('month_year', null, array('placeholder' => __('administrator.month'),'class' => 'form-control month_year','autocomplete' => 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong class="required">{{__('administrator.from_date')}}:</strong>
                                        {!! Form::text('from_date',null, array('placeholder'=>__('administrator.from_date'),'class' => 'form-control  date_picker', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>
                                <div class="col-xs-4 col-sm-4 col-md-4">
                                    <div class="form-group">
                                        <strong class="required">{{__('administrator.to_date')}}:</strong>
                                        {!! Form::text('to_date',null, array('placeholder'=>__('administrator.to_date'),'class' => 'form-control  date_picker', 'autocomplete' => 'off','' )) !!}
                                    </div>
                                </div>

                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        @include('hr.generate-salary.script')
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success btn-save"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function(){
            $('.btn-save').hide();
        });
        function checkAll(classAll, classEach) {

                $('body').on('change', '.' + classAll, function (e) {
                    var status = this.checked;
                    $('.' + classEach).each(function () {
                        this.checked = status;
                    });
                });

                $('body').on('change', '.' + classEach, function (e) {

                    if (this.checked == false) {
                        $("." + classAll)[0].checked = false;
                    }


                    if ($('.' + classEach + ':checked').length == $('.' + classEach).length) {
                        $("." + classAll)[0].checked = true;
                    }
                });
            }
    </script>
@endsection



