@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.resign")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.resign")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($emp_resign, ['method' => 'PATCH','route' => ['hr-emp-resign.update', $id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                @php
                                    $emp = \App\User::find($id);
                                @endphp
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.code')}}</label>
                                    {!! Form::text('code', $emp_resign->user_code, array('class' => 'form-control','disabled','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::text('emp_id', $emp_resign->name, array('class' => 'form-control','disabled','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.resign_date')}}</label>
                                    {!! Form::text('resign_date', null, array('class' => 'form-control date_picker','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.reason')}}</label>
                                    {!! Form::text('reason', null, array('class' => 'form-control ','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.status')}}</label>
                                    {!! Form::select('status',['1' => 'Active',
                                                            '0' => 'Inactive'], null,
                                                            array('class' => 'form-control select2','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.type')}}</label>
                                    {!! Form::select('type',['proper_resign'    => 'Proper Resign',
                                                            'termination'       => 'Termination',
                                                            'dismiss'           => 'Dismiss',
                                                            'other'             => 'Other'] ,null,
                                                            array('class' => 'form-control select2','required')) !!}
                                    
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection




