@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.new")}} {{__("administrator.loan")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.loan")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-emp-loan.store','method'=>'POST')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp_id', $emp, null, array('class' => 'form-control select2','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.loan_type')}}</strong>
                                        {!! Form::select('loan_type',[
                                                    '' => 'Please select',
                                                    'personal' => 'Personal',
                                                    'family'   => 'Family',
                                                    'other'    => 'Other'
                                                    ],null , array('class' => 'form-control select2','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.month')}}</strong>
                                        {!! Form::text('month',null, array('class' => 'form-control month_year','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.amount')}}</strong>
                                        {!! Form::text('amount',null, array('class' => 'form-control number-only','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.date')}}</strong>
                                        {!! Form::text('date',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.interest')}}</strong>
                                        {!! Form::text('interest',null, array('class' => 'form-control number-only','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
        
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.duration')}}</strong>
                                        {!! Form::text('duration',null, array('class' => 'form-control number-only','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.start_date')}}</strong>
                                        {!! Form::text('start_date',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.end_date')}}</strong>
                                        {!! Form::text('end_date',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.disbursement')}}</strong>
                                        {!! Form::text('disbursement',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-4 col-xs-4">
                                    <div class="">
                                        <strong class=""  for="name">{{__('administrator.remark')}}</strong>
                                        {!! Form::text('remark',null, array('class' => 'form-control','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection



