@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.benefit")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.benefit")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($emp_benefit, ['method' => 'PATCH','route' => ['hr-employee-benefit.update', $emp_benefit->emp_id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::text('employee', $emp->english_name, array('placeholder'=>__('administrator.employee'),'class' => 'form-control','readonly')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.benefit_type')}}</label>
                                    {!! Form::select('benefit_type', $benefit_type, null, ['placeholder' => 'Please Select', 'class' => 'form-control select2 benefit_type', 'required']) !!}
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <table width="100%" class="table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Amount</th>
                                                <th style="width: 50px;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody class="tbody-benefit">
                                            @if (isset($benefit))
                                                @if (count($benefit) > 0)
                                                    @foreach ($benefit as $key => $value)
                                                        <tr class="benifit-tr">
                                                            <td class="r-no">{{$key+1}}</td>
                                                            <td>
                                                                <input type="hidden" name="benefit_id[]" value="{{$value->benefit_id}}">
                                                                <input type="text" name="" value="{{optional($value->get_benefit)->name}}" class="form-control id{{$value->benefit_id}}" readonly>
                                                            </td>
                                                            <td><input type="number" name="amount[]" value="{{$value->amount ? $value->amount : ""}}" class="form-control" required></td>
                                                            <td><button type="button" class="remove_row btn button_danger"><i class="fa fa-trash"></i></button></td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function(){
            $(document).on('change', '.benefit_type', function(){
                var id = $(this).find(':selected').val();
                var check = $(".id" + id).val();

                if(check == null && id != ''){
                    $.ajax({
                        type : "POST",
                        dataType: "JSON",
                        url : "{{route('hr.get-benefit-type')}}",
                        data : {
                            "_token": "{{ csrf_token() }}",
                                "id": id,
                        },
                        success: function(data){
                            var row =  `<tr class="benifit-tr">
                                            <td class="r-no">${$(".benifit-tr").length+1}</td>
                                            <td>
                                                <input type="hidden" name="benefit_id[]" value="${id}"></input>
                                                <input type="text" name="" value="${data.name}" class="form-control id${id}" readonly></input>
                                            </td>
                                            <td><input type="number" name="amount[]" value="${data.amount}" class="form-control" required></input></td>
                                            <td><button type="button" class="remove_row btn button_danger"><i class="fa fa-trash"></i></button></td>
                                        </tr>`;
                            $('.tbody-benefit').append(row);
                        },
                        error: function(){
                            console.log('error');
                        }
                    });
                }
            });
        });
        $(document).ready(function () {
            $(document).on('click', '.remove_row', function () {
                var index_ = $(this).data('index');
                $(this).closest('tr').remove();
                $(".r-no").text($(".benifit-tr").length);
            });
        });
    </script>
@endsection



