@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.Dashboard')}}</a></li>
            <li><a href="{{route('hr-company-structure.index')}}">{{__('administrator.company_structure')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.company_structure')}}</h3>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        {!! Form::open(array('route' => 'hr-company-structure.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
        <div class="row">
            <div class="col-sm-12">
                <div class="master-form">
                    <div class="title-note">
                        <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.company_structure')}}
                            <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.name')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::text('name', null, array('placeholder' => __('administrator.name'),'class' => 'form-control','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.type')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::select('type',['company'=>'Company','head-office'=>'Head Office','regional-office'=>'Regional Office','department'=>'Department','unit'=>'Unit','sub-unit'=>'Sub Unit','other'=>'Other'], null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.parent')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::select('parent',$parent, null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="" for="name">{{__('administrator.address')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::textarea('address', null, array('placeholder' => __('administrator.address'),'class' => 'form-control no-resize','rows'=>'3')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="" for="name">{{__('administrator.note')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control no-resize','rows'=>'3')) !!}
                        </div>
                    </div>

                    <div class="col-sm-9 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class=" button_primary pull-right"><span
                                        class="fa fa-save"></span> {{__('administrator.save')}}</button>
                            <button type="button" onClick="history.go(-1)"
                                    class=" button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
@endsection


    

