@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header pull-left">
                    <h3 class="modal-title">{{ __('administrator.are_you_sure')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <form role="form" method="POST" id="form_update">
                    {{csrf_field()}}
                    <div class="modal-body">
                        <input type="hidden" name="id" id="id">
                        <h6>{{ __('administrator.candidate')}} : <span id="name-candidate" class="text-red"> </span> {{ __('administrator.will_delete')}}
                        </h6>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-sm btn-danger"><i
                                    class="fa fa-times"></i> {{ __('administrator.close')}}
                        </button>
                        <button type="submit" class="btn btn-sm btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> {{ __('administrator.save')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{ __('administrator.info_detail') }} </h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <table class="table table-detail">
                            <tr>
                                <td>{{ __('administrator.job_position') }}</td>
                                <td> <span class="job_post_id"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.name') }}</td>
                                <td> <span class="name"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.sex') }}</td>
                                <td> <span class="gender"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.email') }}</td>
                                <td> <span class="email"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.address') }}</td>
                                <td> <span class="address"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.date_of_birth') }}</td>
                                <td> <span class="date_of_birth"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.expected_salary') }}</td>
                                <td> <span class="expected_salary"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.prefered_industry') }}</td>
                                <td> <span class="prefered_industry"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.total_year_exp') }}</td>
                                <td> <span class="total_year_exp"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.cv') }}</td>
                                <td> <span class="cv"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.note') }}</td>
                                <td> <span class="note"></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.photo') }}</td>
                                <td> <input type="hidden" class="photo"></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                class="fa fa-close"></i> {{ __('administrator.close') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.candidate')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.candidate')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Candidate Create'))
                                    <a class="btn btn-sm btn-success" href="{{route('hr-candidate.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.name')}}</th>
                                        <th>{{ __('administrator.applied_position') }}</th>
                                        <th>{{ __('administrator.sex') }}</th>
                                        <th>{{ __('administrator.contact') }}</th>
                                        <th>{{ __('administrator.email') }}</th>
                                        <th>{{ __('administrator.dob') }}</th>
                                        <th style="width: 20%;">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.delete-candidate', function () {
                $('#id').val($(this).data('id'));
                $('#name-candidate').text($(this).data('name'));
                var url = "{{route('hr.delete-candidate')}}";
                $('#form_update').attr('action', url);
                $('#myModal').modal('show');
            });
            $(document).on('click', '.view-candidate', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "{{route('hr.view-candidate')}}",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.job_post_id').text(data.datas.job_post_id);
                        $('.name').text(': ' + data.datas.name);
                        $('.gender').text(': ' + data.datas.gender);
                        $('.phone').text(': ' + data.datas.phone);
                        $('.email').text(': ' + data.datas.email);
                        $('.address').text(': ' + data.datas.address);
                        $('.date_of_birth').text(': ' + data.datas.date_of_birth);
                        $('.expected_salary').text(': ' + data.datas.expected_salary);
                        $('.prefered_industry').text(': ' + data.datas.prefered_industry);
                        $('.total_year_exp').text(': ' + data.datas.total_year_exp);
                        $('.cv').html(': <a href="images/attachment_file/' + data.datas.cv + '" target="_blank"><span class="fa fa-download"></span>' + data.datas.cv + '</a>');
                        $('.note').text(': ' + data.datas.note);
                        $('.photo').html('<img width="60%" src="images/upload/' + data.datas.photo + '">');
                    }
                });
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]], 
                ajax: "{{ route('datatable.hr-get-candidate') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'firstname'},
                        {data: 'job_post_id'},
                        {data: 'gender'},
                        {data: 'phone'},
                        {data: 'email'},
                        {data: 'date_of_birth'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                    $('#datatable_products tbody :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/full_day/g, '{{__('administrator.full_day')}}').replace(/half_day/g, '{{__('administrator.half_day')}}').replace(/day_off/g, '{{__('administrator.day_off')}}');
                    });
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
