@extends("layouts.master")

@section('content')
    @include('hr.branch.confirm-delete')
    <?php Fun::lang()?>
    <style>
        .jconfirm-content-pane input,
        .jconfirm-content-pane select,
        .jconfirm-content-pane textarea
        {
            margin-bottom: 10px;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.branch")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.branch")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Branch Create')
                                    <a class="btn btn-sm btn-success create_branch" href="#"><span class="fa fa-plus"></span> {{__("application.Create New")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_branch" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.name')}}</th>
                                        <th>{{__('administrator.name_kh')}}</th>
                                        <th>{{__('administrator.phone')}}</th>
                                        <th>{{__('administrator.email')}}</th>
                                        <th>{{__('administrator.address')}}</th>
                                        <th>{{__('administrator.note')}}</th>
                                        <th>{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($branch as $key => $row)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$row->name}}</td>
                                        <td>{{$row->khmer_name}}</td>
                                        <td>{{$row->phone}}</td>
                                        <td>{{$row->email}}</td>
                                        <td>{{$row->address}}</td>
                                        <td>{{$row->note}}</td>
                                        <td>
                                            @can('Branch Edit')
                                                <a data-href="{{route('hr-branch.edit',$row->id)}}" class="btn btn-sm btn-warning btn_edit"
                                                   title="edit"><span class="fa fa-edit"></span> Edit</a>
                                            @endcan
                                            @can('Branch set_main')
                                                <a href="#"
                                                   class="btn btn-sm btn-info @if($row->main==1) button_primary @else button_info @endif"
                                                   data-id="{{$row->id}}" title="set"
                                                   @if($row->main==0)
                                                   onclick="set_main('{{$row->id}}')"
                                                        @endif>
                                                    @if($row->main==1)
                                                        <span class="fa fa-check"></span>
                                                        {{__('administrator.main')}}
                                                    @else
                                                        <span class="fa fa-pen-fancy"></span>
                                                        {{__('administrator.set')}}
                                                    @endif
                                                </a>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">

        function set_main(id) {
            if ($.confirm({
                title: '<strong style="color:darkcyan;">{{__('administrator.change_status')}}</strong>',
                content: "<b>Want to Change Main Branch ? "
                + " </b>Then Click OK",

                buttons: {
                    '{{__('administrator.cancel')}}': {
                        btnClass: 'btn-red',
                        action: function () {
                        }

                    },
                    '{{__('administrator.ok')}}': {
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                type: "GET",
                                dataType: "json",
                                url: '{{route("hr.branch_changeStatus")}}',
                                data: {'id': id},
                                success: function (data) {
                                    location.reload();
                                }
                            });
                        }
                    }
                }
            }))

                return false;
        }

        var $form_content = `
                <input type="text" name="name" class="form-control border-red" required placeholder="{{__('administrator.name')}}" maxlength="50" >
                <input type="text" name="name_kh" class="form-control border-red" required placeholder="{{__('administrator.name_kh')}}" maxlength="50" >
                <input type="text" name="phone" class="form-control border-red" placeholder="{{__('administrator.phone')}}" maxlength="50" >
                <input type="text" name="email" class="form-control border-red" placeholder="{{__('administrator.email')}}" maxlength="50" >
                <textarea name="address" rows="2" maxlength="150" class="no-resize form-control border-red" placeholder="{{__('administrator.address')}}" ></textarea>
                <textarea name="note" rows="3" maxlength="150" class="no-resize form-control" placeholder="{{__('administrator.note')}}" ></textarea>
                `;
        $('.create_branch').on('click', function () {
            form($form_content, '{{__('administrator.submit')}}', '{{__('administrator.create')}}', '{{route('hr-branch.store')}}');
        });
        $('.btn_edit').on('click', function () {
            var url = $(this).data('href');
            $.ajax({
                url: url,
                dataType: 'json',
                method: 'get'
            }).done(function (response) {
                console.log(response);
                form(
                    $form_content,
                    '{{__('administrator.update')}}',
                    '{{__('administrator.edit')}}',
                    '{{route('hr-branch-update')}}',
                    response.name,
                    response.khmer_name,
                    response.phone,
                    response.email,
                    response.address,
                    response.note,
                    response.id
                );
            }).fail(function () {
                console.log(2);
            });
        });

        function form($fcontent = '', btntext = '', title = '', route = '', name = '', name_kh = '', phone = '', email = '', address = '', note = '', id = '') {
            $.confirm({
                title: title + ' {{__('administrator.branch')}}',
                content: $fcontent,
                theme: 'modern',
                buttons: {
                    cancel: {
                        text: '{{__('administrator.cancel')}}',
                        btnClass: 'btn btn-sm btn-red',
                        action: function () {

                        }
                    },
                    submit: {
                        text: btntext,
                        btnClass: 'btn btn-sm btn-info',
                        action: function () {
                            let self = this;
                            let phone = self.$content.find('input[name=phone]').val();
                            let name = self.$content.find('input[name=name]').val();
                            let name_kh = self.$content.find('input[name=name_kh]').val();
                            let email = self.$content.find('input[name=email]').val();
                            let address = self.$content.find('textarea[name=address]').val();
                            let note = self.$content.find('textarea[name=note]').val();
                            self.buttons.submit.disable();
                            $.ajax({
                                url: route,
                                dataType: 'json',
                                data: {
                                    "_token": "{{ csrf_token() }}",
                                    name: name,
                                    name_kh: name_kh,
                                    note: note,
                                    address: address,
                                    phone: phone,
                                    email: email,
                                    id: id,
                                },
                                method: 'post'
                            }).done(function (response) {
                                if (response === 'success') {
                                    window.location.reload();
                                }
                            }).fail(function (xhr) {
                                alertErrorFormController(xhr, self)
                            });
                            return false;
                        }
                    },
                }
            });

            if (id) {
                setTimeout(function () {
                    $(document).find('textarea[name=address]').text(address);

                    $(document).find('textarea[name=note]').text(note);
                    $(document).find('input[name=name]').val(name);
                    $(document).find('input[name=name_kh]').val(name_kh);
                    $(document).find('input[name=phone]').val(phone);
                    $(document).find('input[name=email]').val(email);
                    $(".focus").focus();
                }, 1);
            }
        }

        function alertErrorFormController(xhr, this_ = '')
        {
            let error1 = xhr.responseJSON.errors;
            let error2 = xhr.responseJSON.message;
            let text_err = '<ul class="text-left">';
            if (error1) {
                $.each(error1, function (i, val) {
                    let string = val[0].replace('The ', '');
                    let fletter = string.substr(0, 1);
                    let store = string.replace(fletter, fletter.toUpperCase());
                    text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + store + '</li>';
                });
            }
            if (error2) {
                text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + error2 + '</li>';
            }
            text_err += '</ul>';
            $.alert({
                title: '',
                content: text_err,
                useBootstrap: false,
                boxWidth: '25%',
                theme: 'modern',
                buttons: {
                    close: {
                        text: '{{__('administrator.close')}}',
                        btnClass: 'button_warning',
                    }
                }
            });
            if (this_) {
                this_.buttons.submit.enable();
            }
        }

        $('#datatable_branch').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            }

        });
    </script>
@endsection
