@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <?php
    $h = [];
    $mn = [];
    for($hours=1; $hours<=12; $hours++){
    $h[sprintf('%02d', $hours)] = sprintf('%02d', $hours);
    }
    for($m=0; $m<60; $m++){
    $mn[ sprintf('%02d', $m)] = sprintf('%02d', $m);
    }
    ?>
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.attendance')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.attendance')}}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::open(array('route' => 'hr-attendance.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
        <div class="row">
            <div class="col-sm-12">
                <div class="master-form">
                    <div class="title-note">
                        <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.attendance')}}
                            <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.employee')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::select('emp_id',$employee ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.date')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::text('date', null, array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.time_in')}}</label>
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('f_hh',$h, null, array('placeholder' => __('administrator.hour'),'class' => 'form-control select2')) !!}
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('f_mm',$mn, null, array('placeholder' => __('administrator.minute'),'class' => 'form-control select2')) !!}
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('f_shift',['AM'=>__('administrator.am'),'PM'=>__('administrator.pm')], null, array('placeholder' => __('administrator.shift'),'class' => 'form-control select2')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.time_out')}}</label>
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('t_hh',$h, null, array('placeholder' => __('administrator.hour'),'class' => 'form-control select2')) !!}
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('t_mm',$mn, null, array('placeholder' => __('administrator.minute'),'class' => 'form-control select2')) !!}
                        </div>
                        <div class="col-sm-2">
                            {!! Form::select('t_shift',['AM'=>__('administrator.am'),'PM'=>__('administrator.pm')], null, array('placeholder' => __('administrator.shift'),'class' => 'form-control select2')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class=""  for="name">{{__('administrator.note')}}</label>
                        </div>
                        <div class="col-sm-6">
                            {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control no-resize','rows'=>'3')) !!}
                        </div>
                    </div>

                    <div class="col-sm-9 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class=" button_primary pull-right"><span
                                        class="fa fa-save"></span> {{__('administrator.save')}}</button>
                            <button type="button" onClick="history.go(-1)"
                                    class=" button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
@endsection


    

