@extends("layouts.master")

@section('content')
    @include('hr.attendance-finger-print.confirm-delete')
    @include('hr.attendance-finger-print.import-form')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.attendance')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.attendance')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @if(Gate::check('Attendance Finger Create'))
                                    <a href="{{route('hr-attendance-fingerprint.create')}}" class="btn btn-sm btn-success" ><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endif
                                <a href="javascript:void(0);" class="btn btn-sm btn-info btn_import"><span class="fa fa-file-import"></span> {{__('administrator.import')}}</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_finger_print" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.finger_name')}}</th>
                                        <th>{{__('administrator.fingerprint_no')}}</th>
                                        <th>{{__('administrator.check_in_out')}}</th>
                                        <th>{{__('administrator.check_type')}}</th>
                                        <th>{{__('administrator.type')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $(document).on('click','.btn_import', function(){
                $('#form-import').modal('show');
            });

            $(document).on('click', '.btn_finger_print', function(e){
                e.preventDefault();
                var route = '{{ route("hr.get-attendance-finger-print") }}';

                $.ajax({
                    url:route,
                    method:'GET',
                    data:{

                    },
                    success:function(response){
                        if(response.success){
                            alert(response.message);
                        }else{
                            alert("Error");
                        }
                    },
                    error:function(error){
                        console.log(error);
                    }
                });
            });

            $('#datatable_finger_print').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "{{ route('hr-attendance-fingerprint.index') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', orderable: false, searchable: false},
                        {data: 'finger_print_name'},
                        {data: 'finger_print_no'},
                        {data: 'check_in_out'},
                        {data: 'check_type'},
                        {data: 'attend_type'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }

            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
