@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.advance-salary.confirm-delete')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.advance_salary')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.advance_salary')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Salary Advance Create')
                                    <a class="btn btn-sm btn-success" href="{{route('hr-advance-salary.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee') }}</th>
                                        <th>{{__('administrator.advance_salary')}}</th>
                                        <th>{{__('administrator.effect_date')}}</th>
                                        <th>{{__('administrator.note')}}</th>
                                        <th style="width: 200px">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click','.btn_delete', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('hr-advance-salary.index') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'employee'},
                        {data: 'advance_salary'},
                        {data: 'effect_date'},
                        {data: 'note'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
