@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.advance_salary')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.advance_salary')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($advace_sal, ['method' => 'PATCH','route' => ['hr-advance-salary.update', $advace_sal->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp_id', $employee ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.advance_salary')}}</strong>
                                        {!! Form::text('advance_salary', null, array('placeholder' => __('administrator.advance_salary'),'class' => 'form-control number-only', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.effect_date')}}</strong>
                                        {!! Form::text('effect_date',date('d-m-Y', strtotime($advace_sal->effect_date)), array('placeholder' => __('administrator.effect_date'),'class' => 'form-control date_picker', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class=""  for="name">{{__('administrator.note')}}</strong>
                                        {!! Form::text('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control', 'autocomplete'=>'off')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection




