@extends("layouts.master")
@section("content")
@include("deposit.add_deposit")
@include("deposit.cancel_deposit")
@include("deposit.delete_deposit")
@include('deposit.edit_deposit')
@include('deposit.deposit_pay')
@include("client-payment.add-commission")
@include("client-payment.edit-commission")
{{-- remark promotion --}}
<div class="modal fade" id="remark-promotion-deposit">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Remark")}} {{__("application.Promotion")}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      {!! Form::open(['url'=>route('deposit.remark_promotion'),'method'=>'POST','id'=>'form-remark-promotion']) !!}
      @csrf
      <div class="modal-body m-2">
        <input type="hidden" name = "sale_id" id="remark-promotion-sale-id">
        <div class="row">
          <div class="col-md-12">
              <label>{{ __('application.Description') }}</label>
            <div class="form-group">
            {!! Form::textarea('remark_promotion',null, array('class' => 'form-control remark_promotion','rows'=>'5')) !!}
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success btn-sm">{{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
{{-- End --}}
<!--Client Relationship-->
<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="client-relationship">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Form")}} {{__("application.Client Relationship")}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      {!! Form::open(['url'=>route('get_post_client_relationship'),'method'=>'POST']) !!}
      <div class="modal-body m-2">
        <input type="hidden" name = "sale_id" id="client-relationshiop-sale-id">
        <div class="list-client-relationship">
          <div class="row">
            <div class="col-md-6">
                <label>Client Relationship</label>
              <div class="form-group">
              {!! Form::select('client_relationship_id[]',[],null, array('class' => 'form-control select2 client_relationship_id')) !!}
              </div>
            </div>
            <div class="col-md-5">
                <label>Type</label>
              <div class="form-group">
              {!! Form::text('client_relationship_type[]',null, array('placeholder' => 'Type','class' => 'form-control client_relationship_type')) !!}
              </div>
            </div>
            <div class="col-md-1" style="margin-top:30px !important;">
                <button class="btn btn-sm btn-danger" disabled type="button"><i class="fa fa-trash"></i></button>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info btn-sm" onclick = "add_more_record_relationship(this)">{{ __('application.Add') }} {{ __('application.More') }}</button>
        <button type="submit" class="btn btn-success btn-sm">{{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!--End-->
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Deposit")}} </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item active">{{__("application.Deposit")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Deposit-Create-POS')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('pos.create') }}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <div class="card-header" id="card-search-report">
                <h2>{{__("application.Filtering")}}</h2>
                <div class="pull-left">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <strong>{{__("application.Category")}}:</strong>
                                {!! Form::select('category_id',$categories,null, array('class' => 'form-control select2','id'=>'category-id')) !!}
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Project")}}:</strong>
                                {!! Form::select('project',$projects,null, array('class' => 'form-control select2','id'=>'project-id')) !!}
                            </div>
                        </div>
                        <!-- /.col -->
                        <div class="col-md-6">

                            <div class="form-group">
                                <strong>{{__("application.Item")}} {{__("application.Name")}}:</strong>
                                {!! Form::select('item_id',$items,null, array('class' => 'form-control select2','id'=>'item-id')) !!}
                            </div>
                            <div class="form-group">
                                <strong>{{__("application.Client")}}:</strong>
                                {!! Form::select('client_id',$client,null, array('class' => 'form-control select2','id'=>'client-id')) !!}
                            </div>
                        </div>
                        <!-- /.col -->
                        <div class="col-md-6">
                            <button class="btn btn-success btn-md" id="search-form">{{__("application.Search")}}</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-deposit" class="table table-bordered table-hover text-nowrap" style="width:100%">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Date")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Phone")}}</th>
                  <th>{{__("application.Agency")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Category")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Project")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Date")}} {{__("application.Contract")}}</th>
                  <th>{{__("application.Payment")}} {{__("application.Policy")}}</th>
                  <th>{{__("application.Amount")}} {{__("application.Sale")}}</th>
                  <th>{{__("application.Amount")}} {{__("application.Discount")}}</th>
                  <th>{{__("application.Sale")}} {{__("application.Price")}}</th>
                  <th>{{__("application.Amount")}} {{__("application.Deposit")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

<!-- /.modal -->
@endsection
@section('js')
<script>
  function promotion_remark(obj){
    $("#main-spinner").show();
    let sale_id = $(obj).attr("sale_id");
    let remark = $(obj).attr("promotion-remark");
    $("#remark-promotion-deposit").modal('show');
    $("#remark-promotion-sale-id").val(sale_id);
    $(".remark_promotion").val(remark);
  }
  $(document).on('submit','#form-remark-promotion',function(e){
    e.preventDefault();
    console.log($(this).serialize());
    let route = "{{ route('deposit.remark_promotion') }}";
    $("#main-spinner").show();
    $.ajax({
      url:route,
      type:"POST",
      dataType:"JSON",
      data:$(this).serialize(),
      success:function(data){
        if(data.status==true){
          toastr.success("Add remark successfully !");
          $('#datable-deposit').DataTable().draw(true);
        }else{
          toastr.warning("Your request is unsuccess. Please try again!");
        }
      },
      error:function(data){
        toastr.warning("Your request is unsuccess. Please try again!");
      },
      complete:function(){
        $("#remark-promotion-deposit").modal('hide');
        $("#main-spinner").hide();
      }
    });
  });
  var client_relationships = {!! $client_relationships !!};
  function loan_option_client_relationship(selected_id){
		var opt = `<option value="">Please Select</option>`;
		$.each(client_relationships,function(index,value){
			if(value.id == selected_id){
				opt += `<option value="${value.id}" selected>${value.name}</option>`;
			}
			else{
				opt += `<option value="${value.id}">${value.name}</option>`;
			}
		});
		return opt;
	}
  function show_client_relationship(sale_id){
    $("#client-relationship").modal("show");
    $("#client-relationshiop-sale-id").val(sale_id);
		var route = "{{route('get_post_client_relationship',':id')}}";
		route = route.replace(":id",sale_id);
		$.ajax({
			url:route,
			type:"GET",
			async:false,
			dataType:"JSON",
			success:function(data){
				$("#edit-client-relationship").modal("show");
				$("input.client_relationship_type").val(data.client_relation_type);
				var opt = `
					<div class="row">
						<div class="col-md-6">
							<label>Client Relationship</label>
							<div class="form-group">
								<select name = 'client_relationship_id[]' class="select2 form-control">
									${loan_option_client_relationship(0)}
								</select>
							</div>
						</div>
						<div class="col-md-5">
							<label>Type</label>
							<div class="form-group">
							{!! Form::text('client_relationship_type[]',null, array('placeholder' => 'Type','class' => 'form-control client_relationship_type')) !!}
							</div>
						</div>
						<div class="col-md-1" style="margin-top:30px !important;">
							<button class="btn btn-sm btn-danger" disabled type="button"><i class="fa fa-trash"></i></button>
						</div>
					</div>
				`;
				if(client_relationships!=null||client_relationships!=undefined){
					if(data!=null){
						var count = 0;
						$(".list-client-relationship").empty();
						$.each(data,function(num,val){
							var button_status = `<button class="btn btn-sm btn-danger" disabled type="button"><i class="fa fa-trash"></i></button>`;
							if(num>0){
								button_status = `<button class="btn btn-sm btn-danger" onclick="$(this).closest('div.row').remove()" type="button"><i class="fa fa-trash"></i></button>`;
							}
							var opt = `
										<div class="row">
											<div class="col-md-6">
												<label>Client Relationship</label>
												<div class="form-group">
													<select name = 'client_relationship_id[]' class="select2 form-control">
														${loan_option_client_relationship(val.id)}
													</select>
												</div>
											</div>
											<div class="col-md-5">
												<label>Type</label>
												<div class="form-group">
												{!! Form::text('client_relationship_type[]',':type', array('placeholder' => 'Type','class' => 'form-control client_relationship_type')) !!}
												</div>
											</div>
											<div class="col-md-1" style="margin-top:30px !important;">
												${button_status}
											</div>
										</div>
									`;
									opt = opt.replace(":type",val.client_relation_type);
									$(".list-client-relationship").append(opt);
						});
					}
				}

        $(".select2").select2({
            theme: 'bootstrap4'
        });
			},
			error:function(){
				$("#edit-client-relationship").modal("show");
				$("#client-relationshiop-sale-id").val(sale_id);
				var opt = '<option value = "">Please Select</option>';
				$.each(client_relationships,function(index,value){
					opt += `<option value = ${value.id}>${value.name}</option>`;
				});
				$("select.client_relationship_id").html(opt);
				$("input.client_relationship_type").val("");
			}
		});
  }
  function add_more_record_relationship(obj){
		$(".list-client-relationship").append(`<div class="row">
							<div class="col-md-6">
								<label>Client Relationship</label>
								<div class="form-group">
								{!! Form::select('client_relationship_id[]',$client_relationships_append,null, array('class' => 'form-control select2 client_relationship_id')) !!}
								</div>
							</div>
							<div class="col-md-5">
								<label>Type</label>
								<div class="form-group">
								{!! Form::text('client_relationship_type[]',null, array('placeholder' => 'Type','class' => 'form-control client_relationship_type')) !!}
								</div>
							</div>
							<div class="col-md-1" style="margin-top:30px !important;">
								<button class="btn btn-sm btn-danger" type="button" onclick = "$(this).closest('div.row').remove()"><i class="fa fa-trash"></i></button>
							</div>
						</div>`);
						$(".select2").select2({
                theme: 'bootstrap4'
            });
	}
  $(document).on("change","#pay-schedule-deposit-payment-method",function(){
    var payment_method = $(this).val();
    if(payment_method==1){
      $(".list-bank-information").html("");
    }else if(payment_method==2){
      var append_element = `
        <div class="row">
            <div class="col-md-6">
                <div class="form-group" style="position: relative;">
                    <strong class="required">{{__("application.From")}} {{__("application.Bank")}} {{__("application.Name")}}:</strong>
                    {!! Form::select('from_bank_name',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <strong class="required">{{__("application.From")}} {{__("application.Bank")}} {{__("application.Account")}}:</strong>
                    {!! Form::text('from_bank_account',null, array('placeholder' => __("application.From")." ".__("application.Bank")." ".__("application.Account"),'class' => 'form-control','required')) !!}
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group" style="position: relative;">
                    <strong class="required">{{__("application.To")}} {{__("application.Bank")}} {{__("application.Name")}}:</strong>
                    {!! Form::select('to_bank_name',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <strong class="required">{{__("application.To")}} {{__("application.Bank")}} {{__("application.Account")}}:</strong>
                    {!! Form::text('to_bank_account',null, array('placeholder' => __("application.To")." ".__("application.Bank")." ".__("application.Account"),'class' => 'form-control','required')) !!}
                </div>
            </div>
        </div>
      `;
      $(".list-bank-information").html(append_element);
    }else if(payment_method==3){
      var append_element = `
        <div class="row">
            <div class="col-md-6">
                <div class="form-group" style="position: relative;">
                    <strong class="required">{{__("application.Bank")}} {{__("application.Of")}} {{__("application.Cheque")}}:</strong>
                    {!! Form::select('bank_of_cheque',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <strong class="required">{{__("application.Cheque")}} {{__("application.Number")}}:</strong>
                    {!! Form::text('cheque_number',null, array('placeholder' => __("application.Cheque")." ".__("application.Number"),'class' => 'form-control','required')) !!}
                </div>
            </div>
        </div>
      `;
      $(".list-bank-information").html(append_element);
    }
    $('.select2').select2({
      theme: 'bootstrap4'
    });
  });
  function save_deposit_edit(){
    var deposit_id = $("#edit-schedule-deposit-id").val();
    var deposit_date = $("#edit-schedule-deposit-date").val();
    var deposit_amount = $("#edit-schedule-deposit-amount").val();
    if(deposit_id==""){
      $("#form-edit-schedule-deposit").modal("hide");
      toastr.error("Error with your request. Please try again !");
    }
    if(deposit_date==""){
      $("#edit-schedule-deposit-date").focus();
      $("#edit-schedule-deposit-date").css("border","1px solid red");
    }
    if(deposit_amount==""){
      $("#edit-schedule-deposit-amount").focus();
      $("#edit-schedule-deposit-amount").css("border","1px solid red");
    }
    else{
      $('.main-spinner').show();
      var route="{{route('deposit.save_edit_deposit')}}";
      $.ajax({
        url:route,
        dataType:"JSON",
        type:"POST",
        data:{
          "_token":"{{csrf_token()}}",
          "deposit_id":deposit_id,
          "deposit_date":deposit_date,
          "deposit_amount":deposit_amount,
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#form-edit-schedule-deposit").modal("hide");
          if(data=="Error"){
            toastr.error("Error with your request. Please try again !");
          }
          else if(data=="Error-Deposit-Amount"){
            toastr.error("Amount deposit must be less than 20% of Sale Price. Please try again !");
          }
          else{
            toastr.success("Deposit successfully !");

            $('#datable-deposit').DataTable().draw(true);
          }
        },
        error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function edit_deposit(obj){

    var id = $(obj).data('id');
    $(".main-spinner").show();
    var route = "{{route('deposit.edit_deposit',':id')}}";
    route=route.replace(":id",id);
    $.ajax({
      url: route,
      type: 'GET',
      dataType: 'JSON'
    })
    .done(function(data) {
      $(".main-spinner").hide();
      $("#form-edit-schedule-deposit").modal("show");
      $("#edit-schedule-deposit-id").val(data.id);
      $("#edit-schedule-deposit-date").val(data.date.split("-")[2]+"-"+data.date.split("-")[1]+"-"+data.date.split("-")[0]);
      $("#edit-schedule-deposit-amount").val(data.amount);
      console.log("success");
    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });

  }
   function pay_deposit(obj){
      var id = $(obj).data('id');
      $("#pay-schedule-deposit-id").val(id);
      $(".main-spinner").show();
      var route = "{{route('deposit.edit_deposit',':id')}}";
      route=route.replace(":id",id);
      $.ajax({
        url: route,
        type: 'GET',
        dataType: 'JSON'
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#form-pay-schedule-deposit").modal("show");
        $("#pay-schedule-deposit-id").val(data.id);
        $("#pay-schedule-deposit-date").val(data.date.split("-")[2]+"-"+data.date.split("-")[1]+"-"+data.date.split("-")[0]);
        $("#pay-schedule-deposit-amount").val(data.amount);
        $("#pay-schedule-deposit-sale_id").val(data.sale_id);
        console.log("success");
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
   }
  function view_deposit_detail(sale_id,obj){
    var route = "{{ route('get-all-deposit') }}";
    var tr="";
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"post",
      dataType:"JSON",
      async:false,
      data:{
        "_token":"{{ csrf_token() }}",
        "sale_id":sale_id
      },
      success:function(data){
        $(".main-spinner").hide();
        $.each(data['data_deposit'],function(index,val){

          var des="";var route_print="";var route_edit_deposit="";var paid_date = "";

          route_edit_deposit='{{ route("deposit.edit_deposit",":id") }}';
          route_edit_deposit=route_edit_deposit.replace(":id",val.id);

          var button = "";
          if(val.pay_type==0){
            button+=` <button type="button" data-id="${val.id}" onclick="pay_deposit(this)" target='_blank' class='btn btn-sm btn-info' title='Pay Deposit'>
                          <i class='fas fa-dollar-sign'></i>
                      </button>`;
          }
          if(val.pay_type==0&&val.paid_amount==0){
              button+=` <button type="button" data-id="${val.id}" onclick="edit_deposit(this)" target='_blank' class='btn btn-sm btn-info' title='Edit Deposit'>
                          <i class='fas fa-edit'></i>
                      </button>`;
          }
          if(val.pay_type==1){
            var route_get_deposit = "{{ route('get_deposit_data_print',':id') }}";
            route_get_deposit = route_get_deposit.replace(":id",sale_id);
            $(".main-spinner").show();
            $.ajax({
              url:route_get_deposit,
              type:"GET",
              dataType:"JSON",
              async:false,
              success:function(data_deposit){
                $(".main-spinner").hide();
                $.each(data_deposit,function(index_d,val_d){
                  if(val.id == val_d.deposit_schedule_id){
                    paid_date = val_d.date;
                    route_print='{{ route("deposit.print_invoice",":id") }}';
                    route_print=route_print.replace(":id",val_d.id);
                    button += `
                                <a href='${route_print}' target='_blank' class='btn btn-sm btn-primary' title='Print'>
                                    <i class='fas fa-print'></i>
                                </a>`;
                  }
                });
              },
              error:function(data){
                $(".main-spinner").hide();
              },
            });
          }
          tr+=`
              <tr>
                <td style="text-align:center;">${index+1}</td>
                <td style="text-align:center;">${val.date.split("-")[2]+"-"+val.date.split("-")[1]+"-"+val.date.split("-")[0]}</td>
                <td style="text-align:center;">${val.amount}$</td>
                <td style="text-align:center;">${paid_date}</td>
                <td style="text-align:center;">${val.paid_amount}$</td>
                <td style="text-align:center;">
                  ${button}
                </td>
              </tr>`;
        });
      }
    });
    var table_append=`<tr id="tb-deposit-detail-${sale_id}" with="100%">
                        <td colspan="15">
                         <table class="table table-bordered table-hover text-nowrap">
                            <thead>
                              <tr><th colspan="6" style="text-align:center;">{{__("application.Deposit")}} {{__("application.Schedule")}}</th></tr>
                              <tr>
                                <th style="text-align:center">{{__("application.No")}}</th>
                                <th style="text-align:center">{{__("application.Date")}}</th>
                                <th style="text-align:center">{{__("application.Amount")}}</th>
                                <th style="text-align:center">{{__("application.Paid")}} {{__("application.Date")}}</th>
                                <th style="text-align:center">{{__("application.Paid")}} {{__("application.Amount")}}</th>
                                <th style="text-align:center">{{__("application.Action")}}</th>
                              </tr>
                            </thead>
                            <tbody>
                              ${tr}
                            </tbody>
                         </table>
                        </td>
                      </tr>`;
    if($('tr#'+sale_id).hasClass("parent")){
        $("tr#"+sale_id).next().after(table_append);
    }else{
          $("tr#"+sale_id).after(table_append);

    }
    var btn_close_view=`
            <a href='javascript:void(0)' onclick='close_view_history(${sale_id},this)' class='btn btn-sm btn-warning' title='close view withdraw history'>
                <i class="far fa-eye-slash"></i>
            </a>
            `;
    $(obj).before(btn_close_view);
    $(obj).hide();
  }
  function close_view_history(id,obj){
    $("tr#tb-deposit-detail-"+id).remove();
    $(obj).next().show();
    $(obj).remove();
  }
  //For correct view commission history
  window.addEventListener("resize", resizeFunction);
  function resizeFunction() {
    window.location.reload();
  }
  //end


  function delete_deposit(id){
    $("#delete-deposit").modal("show");
    $("input#deposit-delete-id").val(id);
  }
  function submit_delete_deposit(){
    var sale_id=$("input#deposit-delete-id").val();
    if(sale_id==""){
      toastr.error("Error with your request. Please try again !");
    }else{
      var route="{{route('deposit.delete_deposit')}}";
      $('.main-spinner').show();
      $.ajax({
        url:route,
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          "sale_id":sale_id
        },success:function(data){
          $('.main-spinner').hide();
          $("#delete-deposit").modal("hide");
          toastr.success("Delete successfully !");
          if($(`tbody tr#${data}`).hasClass("parent")){
            $(`tbody tr#${data}`).next().remove();
            $(`tbody tr#${data}`).remove();
          }else{
            $(`tbody tr#${data}`).remove();
          }
        },error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function cancel_deposit(id){
    $("#cancel-deposit").modal("show");
    $("input#deposit-id").val(id);
  }
  function submit_cancel_deposit(){
    var sale_id=$("input#deposit-id").val();
    var amount_cancel=$("input#amount_cancel").val();
    if(sale_id==""){
      toastr.error("Error with your request. Please try again !");
    }else{
      var route="{{route('deposit.cancel_deposit')}}";
      $('.main-spinner').show();
      $.ajax({
        url:route,
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          "sale_id":sale_id,
          "amount_cancel":amount_cancel
        },success:function(data){
          $('.main-spinner').hide();
          $("#cancel-deposit").modal("hide");
          toastr.success("Cancel successfully !");
          if($(`tbody tr#${data}`).hasClass("parent")){
            $(`tbody tr#${data}`).next().remove();
            $(`tbody tr#${data}`).remove();
          }else{
            $(`tbody tr#${data}`).remove();
          }
        },error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function get_deposit_info(id){
    var route="{{route('deposit.get_deposit')}}";
    $('.main-spinner').show();
    $.ajax({
      url:route,
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        "sale_id":id
      },
      success:function(data){
        $('.main-spinner').hide();
        $("#add-deposit").modal("show");
        $("#deposit-date-on-contract").val(data);
        $("#sale-id").val(id);
      },
      error:function(){
        toastr.error("Error with your request. Please try again !");
      }
    });
  }
  function save_deposit(){
    var sale_id = $("#sale-id").val();
    var deposit_date = $("#deposit-date").val();
    var deposit_date_contract = $("#deposit-date-on-contract").val();
    var deposit_amount = $("#deposit-amount").val();
    var deposit_accountant = $("#deposit-accountant").val();
    var deposit_description = $("#deposit-description").val();
    var bank_list = $("#bank_list").val();
    if(sale_id==""){
      $("#add-deposit").modal("hide");
      toastr.error("Error with your request. Please try again !");
    }
    if(deposit_date==""){
      $("#deposit-date").focus();
      $("#deposit-date").css("border","1px solid red");
    }
    else if(deposit_date_contract==""){
      $("#deposit-date-on-contract").focus();
      $("#deposit-date-on-contract").css("border","1px solid red");
    }else if(deposit_amount==""){
      $("#deposit-amount").focus();
      $("#deposit-amount").css("border","1px solid red");
    }
    else if(bank_list==""){
      $("#bank_list").focus();
      $("#bank_list").css("border","1px solid red");
    }
    else{
      $('.main-spinner').show();
      var route="{{route('deposit.add_more_deposit')}}";
      $.ajax({
        url:route,
        dataType:"JSON",
        type:"POST",
        data:{
          "_token":"{{csrf_token()}}",
          "sale_id":sale_id,
          "deposit_date":deposit_date,
          "deposit_date_contract":deposit_date_contract,
          "deposit_amount":deposit_amount,
          "deposit_accountant":deposit_accountant,
          "deposit_description":deposit_description,
          "bank_list":bank_list
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#add-deposit").modal("hide");
          if(data=="Error"){
            toastr.error("Error with your request. Please try again !");
          }else if(data=="Error-Deposit-Amount"){
            toastr.error("Amount deposit must be less than 20% of Sale Price. Please try again !");
          }
          else{
            toastr.success("Deposit successfully !");
            $(`span#contract-date${sale_id}`).text(data.date_contract);
            $(`span#receive-amount${sale_id}`).text(data.sale_receive_amount+"$");
            $(`span#invoice${sale_id}`).empty();
            var opt="";
            $.each(data['deposit_data'],function(index,val){
              var route="{{route("deposit.print_invoice",":id")}}";
              route=route.replace(":id",val.id);
              var date=val.date;
              opt+=` <a href="${route}" target="_blank" class="btn btn-primary btn-sm" title="Print invoice ( ${date} )"><i class="fas fa-print"></i></a> `;
            });
            $(`span#invoice${sale_id}`).append(opt);
            $('#datable-deposit').DataTable().draw(true);
          }
        },
        error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-deposit').DataTable({
          "autoWidth": false,
          ordering: true,
          serverSide: true,
          "scrollY": screen.height,
          "scrollX": true,
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              }
          ],
          ajax: {
              url:"{{ route('deposit.get_deposit') }}",
              type:"GET",
              data:function(d){
                  var category_id = $("#category-id").val();
                  var item_id = $("#item-id").val();
                  var project_id = $("#project-id").val();
                  var client_id = $("#client-id").val();
                  d.category_id=category_id;
                  d.item_id=item_id;
                  d.project_id=project_id;
                  d.client_id=client_id;
              }
          },

          columns:
          [
              {data: 'DT_RowIndex','searchable': false,orderable:false},
              {data: 'date','name':'nso007_sale_stock.date'},
              {data: 'client_name','name':'nso007_client.name'},
              {data: 'client_phone','name':'nso007_client.phone'},
              {data: 'agency_name','name':'nso007_agency.name'},
              {data: 'item_name','name':'nso007_item_stock.name'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'date_on_contract','name':'nso007_sale_stock.date_on_contract'},
              {data: 'payment_policy','searchable':false},
              {data: 'sale_amount','searchable': false},
              {data: 'discount_amount','searchable':false},
              {data: 'sale_price','searchable': false},
              {data: 'sale_receive_amount','searchable': false},
              {data: 'action','searchable': false},
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });

  $(document).on('click','#search-form',function(){
      $('#datable-deposit').DataTable().draw(true);
  });
  function get_agency_info(obj){
    var sale_id = $(obj).data("sale-id");
    var agency_id = $(obj).data("agency-id");
    var agency_name = $(obj).data("agency-name");
    $("#sale-id").val(sale_id);
    $("#commission-agency-name").val(agency_name);
    $("#agency-id").val(agency_id);
    $("#commission-amount").val("");
    $("#commission-condition").val("");
    $("#tb-condition-table").empty();
    $("#group-condition").hide();
    $("#add-commission").modal("show");
  }
  $(document).on("change","#edit-commission-condition",function(){
    if($(this).val()==""){
      $("#group-condition-edit").hide();
      $("#tb-condition-table-edit").empty();
    }
    else edit_get_commission_condition($(this).val());
  });
  function edit_get_commission_condition(id)
  {
    $('.main-spinner').show();
    var route = "{{route('edit_commission_condition',':id')}}";
    route = route.replace(":id",id);
    $.ajax({
        url: route,
        type: 'GET',
        dataType: 'JSON'
      })
      .done(function(data) {
        $('.main-spinner').hide();
        $("#group-condition").show();
        var tr=``;
        $.each(data['commission_condition_detail'],function(index,value){
          var type_commission = "";
          if(value.commission_type==1){
            type_commission = "Booking Commission";
          }else{
            type_commission = "Monthly Payment Commission";
          }
          tr+=`<tr class='edit-no-tb'>
                  <td>
                      <input type="text" value="${type_commission}" class="form-control nso-amount-input-step" name="type[]"
                      placeholder="Type Commission" readonly required>
                  </td>
                  <td>
                      <input type="number" class="form-control nso-amount-input-step" name="condition[]"
                      placeholder="To (%)" readonly value="${value.commission_condition}" required step="any">
                  </td>
                  <td>
                      <input type="number" readonly class="form-control" value="${value.can_withdraw_condion}" name="withdrawable[]" placeholder="%" required step="any">
                  </td>
              </tr>`;
        });
        $("#tb-condition-table-edit").empty();
        $("#tb-condition-table-edit").append(tr);
        $("#tb-condition-table-edit").find("tr").first().find("td").last().find("button").attr("disabled",true);
      })
      .always(function() {
        console.log("complete");
      });

  }
  $(document).on("change","#commission-condition",function(){
    if($(this).val()==""){
      $("#group-condition").hide();
      $("#tb-condition-table").empty();
    }
    else get_commission_condition($(this).val());
  });

  function get_commission_condition(id)
  {
    $('.main-spinner').show();
    var route = "{{route('edit_commission_condition',':id')}}";
    route = route.replace(":id",id);
    $.ajax({
        url: route,
        type: 'GET',
        dataType: 'JSON'
      })
      .done(function(data) {
        $('.main-spinner').hide();
        $("#group-condition").show();
        var tr=``;
        $.each(data['commission_condition_detail'],function(index,value){
          var type_commission = "";var condition = "";
          if(value.commission_type==1){
            type_commission = "Booking Commission";
            condition = value.commission_condition;
          }else{
            type_commission = "Monthly Payment Commission";
            condition = "Monthly";
          }
          tr+=`<tr class='edit-no-tb'>
                  <td>
                      <input type="text" value="${type_commission}" class="form-control nso-amount-input-step" name="type[]"
                      placeholder="Type Commission" readonly required>
                  </td>
                  <td>
                      <input type="text" class="form-control nso-amount-input-step" name="condition[]"
                      placeholder="Condition" readonly value="${condition}" required>
                  </td>
                  <td>
                      <input type="number" readonly class="form-control" value="${value.can_withdraw_condion}" name="withdrawable[]" placeholder="%" required step="any">
                  </td>
              </tr>`;
        });
        $("#tb-condition-table").empty();
        $("#tb-condition-table").append(tr);
        $("#tb-condition-table").find("tr").first().find("td").last().find("button").attr("disabled",true);
      })
      .always(function() {
        console.log("complete");
      });

  }
  function save_edit_commission(){
    var date = $("#commission-date-edit").val();
    var sale_id = $("#sale-id-edit").val();
    var agency_id = $("#agency-id-edit").val();
    var commission_amount = $("#commission-amount-edit").val();
    var edit_commission_condition = $("#edit-commission-condition").val();
    if(date==""){
      $("#commission-date-edit").css("border","1px solid red");
      $("#commission-date-edit").focus();
    }else if(sale_id==""){
      toastr.warning("Error your request. Please tr again !");
    }else if(agency_id==""){
      toastr.warning("Error your request. Please tr again !");
    }else if(commission_amount==""){
      $("#commission-amount-edit").css("border","1px solid red");
      $("#commission-amount-edit").focus();
    }
    else if(edit_commission_condition=="")
    {
      $("#edit-commission-condition").css("border","1px solid red");
      $("#edit-commission-condition").focus();
    }
    else{
      $("#edit-commission").modal("hide");
      $(".main-spinner").show();
      $.ajax({
        url:"{{ route('client-payment.save_edit_commission') }}",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{ csrf_token() }}",
          "sale_id":sale_id,
          "agency_id":agency_id,
          "commission_amount":commission_amount,
          "date":date,
          'edit_commission_condition':edit_commission_condition
        },
        success:function(data){
          $(".main-spinner").hide();
          toastr.success("Your request is successfullty !");
        }
      });
    }
  }
  function edit_commission(sale_id){
    var route="{{ route('client-payment.get_edit_commission') }}";
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{ csrf_token() }}",
        "sale_id":sale_id,
      },
      success:function(data){
        $(".main-spinner").hide();
        console.log(data['data_commission'].withdraw_status);
        if(data['data_commission'].withdraw_status==1||data['data_commission'].withdraw_status==2){
          toastr.warning("Commission have been drawing! so, your request is fail !");
        }
        else{
          $("#edit-commission").modal("show");
          $("#commission-date-edit").val(data['data_commission'].date.split("-")[2]+"-"+data['data_commission'].date.split("-")[1]+"-"+data['data_commission'].date.split("-")[0]);
          $("#sale-id-edit").val(data['data_commission'].sale_id);
          $("#agency-id-edit").val(data['data_commission'].agency_id);
          $("#commission-agency-name-edit").val(data['data_commission'].agency_name);
          $("#commission-amount-edit").val(data['data_commission'].commission_amount);
          var tr="";
          var opt="";
          var commission_condition = data['commission_condition_setting'];
          $.each(commission_condition,function(index, el) {

            if(el.id==data['commission_condition'][0].commission_condition_id) opt+=`<option selected value="${el.id}">${el.title}</option>`;
            else opt+=`<option value="${el.id}">${el.title}</option>`;

          });
          $("#edit-commission-condition").empty();
          $("#edit-commission-condition").append(opt);
          $.each(data['commission_condition'],function(index,val){

            var type_commission = "";var condition = "";
            if(val.commission_type==1){
              type_commission = "Booking Commission";
              condition = val.commission_condition;
            }else{
              type_commission = "Monthly Payment Commission";
              condition = "Monthly";
            }
            tr+=`<tr class='edit-no-tb'>
                  <td>
                      <input type="text" value="${type_commission}" class="form-control nso-amount-input-step" name="type[]"
                      placeholder="Type Commission" readonly required>
                  </td>
                  <td>
                      <input type="text" class="form-control nso-amount-input-step" name="condition[]"
                      placeholder="Condition" readonly value="${condition}" required>
                  </td>
                  <td>
                      <input type="number" readonly class="form-control" value="${val.can_withdraw_condion}" name="withdrawable[]" placeholder="%" required step="any">
                  </td>
              </tr>`;

          });
          $("#tb-condition-table-edit").empty();
          $("#tb-condition-table-edit").append(tr);
        }
      }
    });
  }
  function save_commission(){
    var date = $("#commission-date").val();
    var sale_id = $("#sale-id").val();
    var agency_id = $("#agency-id").val();
    var commission_condition = $("#commission-condition").val();
    var commission_amount = $("#commission-amount").val();
    if(date==""){
      $("#commission-date").css("border","1px solid red");
      $("#commission-date").focus();
    }else if(sale_id==""){
      toastr.warning("Error your request. Please tr again !");
    }else if(agency_id==""){
      toastr.warning("Error your request. Please tr again !");
    }else if(commission_amount==""){
      $("#commission-amount").css("border","1px solid red");
      $("#commission-amount").focus();
    }else if(commission_condition==""){
      $("#commission-condition").css("border","1px solid red");
      $("#commission-condition").focus();
    }
    else{
      $("#add-commission").modal("hide");
      $(".main-spinner").show();
      $.ajax({
        url:"{{ route('client-payment.add_commission') }}",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{ csrf_token() }}",
          "sale_id":sale_id,
          "agency_id":agency_id,
          "commission_amount":commission_amount,
          "date":date,
          "commission_condition":commission_condition
        },
        success:function(data){
          if(data.commission_status==1){
            $(".main-spinner").hide();
            $("span#commission-"+sale_id).empty();
            $("span#commission-"+sale_id).append(`<button class ="btn btn-sm btn-primary" title="Edit Commission to agency" data-toggle="modal" onclick="edit_commission(${sale_id})"><i class = "fa fa-edit"></i></button>`);
            toastr.success("Your request is successfullty !");
          }
        }
      });
    }
  }
</script>
@endsection
