@extends("layouts.master")
@section("content")
@include("pos.create-new-client",compact('provinces'))
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    } 
    ul.list-group{
      position: absolute;
      z-index: 100000000000;
      width: 94%;
    }
    li.list-group-item:hover{
      background-color: #4CAF50;
      color: white;
      /*font-size: 16px;*/
      border: none;
      cursor: pointer;
      width: 100% !important;
    }
    .jconfirm {
      z-index: 1;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__('application.Edit')}} {{__("application.POS")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item"><a href="{{route('deposit.index')}}">{{__("application.Deposit")}}</a></li>
              <li class="breadcrumb-item active">{{__('application.Edit')}} {{__("application.POS")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Info boxes -->
        <!-- /.row -->

        <!-- Main row -->
        <div class="row">
          <!-- Left col -->
          <div class="col-md-8">
            <!-- TABLE: LATEST ORDERS -->
            <div class="card">
              <div class="card-header border-transparent">
                <h3 class="card-title">{{__("application.Item")}} {{__("application.For")}} {{__("application.Order")}}</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" disabled class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table m-0" id="pos-item">
                    <thead>
                    <tr>
                      <th>{{__("application.No")}}</th>
                      <th>{{__("application.Item")}}</th>
                      <th>{{__("application.Price")}}</th>
                      <th>{{__("application.Category")}}</th>
                      <th>{{__("application.Project")}}</th>
                      <th>{{__("application.Action")}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
                <!-- /.table-responsive -->
              </div>
              <!-- /.card-body -->
              <!-- <div class="card-footer clearfix">
                <a href="javascript:void(0)" class="btn btn-sm btn-info float-left">Place New Order</a>
                <a href="javascript:void(0)" class="btn btn-sm btn-secondary float-right">View All Orders</a>
              </div> -->
              <!-- /.card-footer -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->

          <div class="col-md-4">
            <!-- PRODUCT LIST -->
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">{{__("application.Recently")}} {{__("application.Added")}} {{__("application.Item")}}</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" disabled class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body p-0">
                <ul class="products-list product-list-in-card pl-2 pr-2" id="order-list">
                  @if(session()->has("Cart_Deposit"))
                    @foreach(session()->get("Cart_Deposit") as $key => $value)
                      <li class="item" id="item-order-{{$value['id']}}">
                        <div class="product-info" style="margin-left: 25px;">
                          <a href="javascript:void(0)" class="product-title">{{$value['name']}}
                            <span class="badge badge-warning float-right">${{$value['price']}}</span></a>
                          <span class="product-description">
                            {{__("application.Project")}} : {{$value['project_name']}}, Size : {{$value['size']}}
                          </span>
                        </div>
                      </li>
                    @endforeach
                  @endif
                </ul>
              </div>
              <!-- /.card-body -->
              <a href="javascript:void(0)" id="btn-add-deposit" class="uppercase" title="Add Deposit">
                <div class="card-footer text-center">
                    <u>{{__("application.Deposit")}}</u>
                </div>
              </a>
              <!-- /.card-footer -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div><!--/. container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script>
  $(document).on("submit","#form-deposit",function(e){

    var checkInner=$("#order-list li");
    if(checkInner.length<=0){
      e.preventDefault();
      toastr.warning("Please add item to cart !");
    }else{
      $("#form-deposit").submit();
    }
  });
  function Add_To_Cart(obj){
    if($(obj).closest("tr").hasClass("child")){
      var id = $(obj).closest("tr").prev().attr("id");
    }else{
      var id = $(obj).closest("tr").attr("id");
    }
    
    if(id==""){
      toastr.warning("Error with your request. Please try again !");
    }else{
      $('.main-spinner').show();
      var route="{{route('deposit.Add_To_Cart')}}";
      $.ajax({
        type:"post",
        dataType:"JSON",
        url:route,
        data:{
          "_token":"{{csrf_token()}}",
          "id":id
        },
        success:function(message){
          $('.main-spinner').hide();
          if(message.type=="error"){
            toastr.error(message.text);
          }else if(message.type=="exist"){
            toastr.warning(message.text);
          }else if(message.type=="added"){
            toastr.success(message.text);
            var opt="";
            $("#order-list").empty();
            $.each(message.data,function(index,val){
              opt+=`<li class="item" id="item-order-${val.id}">
                    <div class="product-info" style="margin-left: 25px;">
                      <a href="javascript:void(0)" class="product-title">${val.name}
                        <span class="badge badge-warning float-right">$${val.price}</span></a>
                      <span class="product-description">
                        Project : ${val.project_name}, Size : ${val.size}
                      </span>
                    </div>
                  </li>`;
            });
            $("#order-list").append(opt);
            $(obj).closest("td").append(`<button type="button" class="btn btn-info btn-sm" title="Undo ( Remove Item From Cart)" onclick="Remove_From_Cart(this)"><i class="fas fa-undo-alt"></i></button>`);
            $(obj).remove()
          }else{

          }
        },
        error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function Remove_From_Cart(obj){
    
    if($(obj).closest("tr").hasClass("child")){
      var id=$(obj).closest("tr").prev().attr("id");
    }else{
      var id=$(obj).closest("tr").attr("id");
    }
    $('.main-spinner').show();
    var route="{{route('deposit.Remove_From_Cart')}}";
    $.ajax({
      url:route,
      dataType:"JSON",
      type:"POST",
      data:{
        "_token":"{{csrf_token()}}",
        "id":id
      },
      success:function(message){
        $('.main-spinner').hide();
        if(message=="Error"){
          toastr.error("Error with your request. Please try again !");
        }
        else{
          $("#item-order-"+id).remove();
          $(obj).closest("td").append(`<button type="button" class="btn btn-success btn-sm" data-index="${id}" title="Add To Cart" onclick="Add_To_Cart(this)"><i class="fas fa-cart-arrow-down"></i></button>`);
          $(obj).remove()
          toastr.success("Remove from cart successfully !");
        }
      },
      error:function(){
        toastr.error("Error with your request. Please try again !");
      }
    });
  }
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#pos-item').DataTable({  
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          lengthMenu: [[10,20, 30, 50, 100,200,500,1000], [10,20, 30, 50, 100,200,500,1000]],
          ajax: "{{ route('deposit.get_item_edit') }}",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'name','name':'nso007_item_stock.name'},
              {data: 'price','name':'nso007_item_stock.price'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},  
              {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
            $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on("click","#btn-add-deposit",function(){
    $.confirm({
      title: '<br/>Deposit Information!',
      content: `
      <form action="{{route('pos.store')}}" method="POST" id="deposit-form-id" class="formName m-2">
        <div class="row">
          <div class="form-group col-6">
            <strong class="required">{{__("application.Client")}}(<a href="#" id="btn-create-client">create new</a>):</strong>
             <div>
              {!! Form::text('client_id',$clients->name, array('class' => 'form-control client_id','required','id'=>'client-search','autocomplete'=>'off','placeholder'=>"Name")) !!}
              <select name="client" class="client form-control" id="appended-client" style="display:none;">
                <option value="{{$clients->id}}" selected>{{$clients->name}}</option>
              </select>

              <ul class="list-group" id="append-client">
              </ul>
             </div>
          </div>
          <input type="hidden" name="sale_id" value="{{$data_sale_detail[0]->sale_id}}" class="sale_id">
          <div class="form-group col-6">
              <strong class="required">{{__("application.Date")}}:</strong>
              {!! Form::text('date', (!empty($data_sale_detail[0]->date)?date("d-m-Y",strtotime($data_sale_detail[0]->date)):null), array('placeholder' => __("application.Date"),'class' => 'form-control date_picker date-deposit','required')) !!}
          </div>
        </div>
        <div class="row">
          <div class="form-group col-6">
              <strong class="required">{{__("application.Date")}} {{__("application.Contract")}}:</strong>
              {!! Form::text('contract_date', date("d-m-Y",strtotime($data_sale_detail[0]->date_on_contract)), array('placeholder' =>__("application.Date"),'class' => 'form-control date_picker contract_date','required')) !!}
          </div>
          <div class="form-group col-6">
              <strong>{{__("application.Agency")}}:</strong>
              {!! Form::text('agency',optional($agencies)->name, array('class' => 'form-control agency','required','id'=>'agency-search','autocomplete'=>'off','placeholder'=>"Name")) !!}
              <select name="agency" class="agency-id form-control" style="display:none;" id="appended-agency">
                <option value="{{optional($agencies)->id}}">{{optional($agencies)->name}}</option>
              </select>

            <ul class="list-group" id="append-agency">
            </ul>
          </div>
        </div>
      </form>`,
      columnClass: 'col-md-4 col-md-offset-8 col-xs-4 col-xs-offset-8',
      containerFluid: true,
      buttons: {
          formSubmit: {
              text: 'Submit',
              btnClass: 'btn-blue',
              action: function () {
                  var client_id = this.$content.find('.client').val();
                  var agency_id = this.$content.find('.agency-id').val();
                  var date_deposit = this.$content.find('.date-deposit').val();
                  var contract_date = this.$content.find('.contract_date').val();
                  var sale_id = this.$content .find('.sale_id').val();
                  if(!client_id){
                    $.alert('provide a valid Client Name');
                    return false;
                  }
                  // if(!date_deposit){
                  //   $.alert('provide a valid Deposit Date');
                  //   return false;
                  // }
                  if(!contract_date){
                    $.alert('provide a valid Contract Date');
                    return false;
                  }
                  $.ajax({
                    url: '{{route("deposit.update_pos")}}',
                    type: 'POST',
                    dataType: 'JSON',
                    data: {
                      client_id: client_id,
                      agency_id: agency_id,
                      date     : date_deposit,
                      contract_date:contract_date,
                      "_token":"{{csrf_token()}}",
                      sale_id:sale_id
                    },
                  })
                  .done(function(data) {
                    if(data=="OK"){
                      window.location.href="{{route('deposit.index')}}";
                    }
                    else if(data=="BOOKED"){
                      toastr.warning("Some item is booked. Please try again !");
                    }
                    else{
                      window.location.reload();
                      toastr.error("Error with your request. Please try again !");
                    }
                    console.log("success");
                  })
                  .fail(function() {
                    console.log("error");
                    toastr.error("Error with your request. Please try again !");
                  })
                  .always(function() {
                    console.log("complete");
                  });
                  
              }
          },
          cancel: function () {
              //close
          },
      },
      onContentReady: function () {
          // bind to events
          var jc = this;
          this.$content.find('form').on('submit', function (e) {
              // if the user submits the form by pressing enter in the field.
              e.preventDefault();
              jc.$$formSubmit.trigger('click'); // reference the button and click it
          });
      }
    });
    $(document).on("focus","#client-search",function(){
      $(".main-spinner").show();
      $("#append-client").empty();
      $.ajax({
        url: '{{route("get-client-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          client_name: $("#client-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-client").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_client(this)">${val.name}</li>
              `;

        });
        $("#appended-client").empty();
        $("#appended-client").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-client").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("keyup","#client-search",function(){
      $(".main-spinner").show();
      $("#append-client").empty();
      $.ajax({
        url: '{{route("get-client-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          client_name: $("#client-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-client").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_client(this)">${val.name}</li>
              `;

        });
        $("#appended-client").empty();
        $("#appended-client").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-client").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("focus","#agency-search",function(){
      $(".main-spinner").show();
      $("#append-agency").empty();
      $.ajax({
        url: '{{route("get-agency-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          agency_name: $("#agency-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-agency").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_agency(this)">${val.name}</li>
              `;

        });
        $("#appended-agency").empty();
        $("#appended-agency").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-agency").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("keyup","#agency-search",function(){
      $(".main-spinner").show();
      $("#append-agency").empty();
      $.ajax({
        url: '{{route("get-agency-search")}}',
        type: 'POST',
        dataType: 'JSON',
        data: {
          agency_name: $("#agency-search").val(),
          "_token":"{{csrf_token()}}"
        },
      })
      .done(function(data) {
        $(".main-spinner").hide();
        $("#append-agency").empty();
        var opt="";
        $.each(data,function(index, val) {
          opt+=
              `
                <li class="list-group-item" data-id="${val.id}" onclick="select_agency(this)">${val.name}</li>
              `;

        });
        $("#appended-agency").empty();
        $("#appended-agency").append(`<option value="${data[0].id}" selected>${data[0].name}</option>`);
        $("#append-agency").append(opt);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
    });
    $(document).on("click",".date_picker",function(){
      $(this).datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true
      });
    });
  });
  function select_client(obj){
    $("#appended-client").empty();
    $("#append-client").empty();
    $("#appended-client").append(`<option value="${$(obj).data("id")}" selected>${$(obj).text()}</option>`);
    $("#client-search").val($(obj).text());
  }
  function select_agency(obj){
    $("#appended-agency").empty();
    $("#append-agency").empty();
    $("#appended-agency").append(`<option value="${$(obj).data("id")}" selected>${$(obj).text()}</option>`);
    $("#agency-search").val($(obj).text());
  }
  // $(document).on("click","div",function(){
  //   $("#append-agency").empty();
  //   $("#append-client").empty();
  // });
  $(document).on("click","#btn-create-client",function(){
    $("#create-new-client").modal("show");
  });
  $(document).on("submit","#form-create-new-submit",function(e){
    e.preventDefault();
    $('.main-spinner').show();
     $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
      });
      $.ajax({
          url: '{{route("client.store")}}',
          type: 'POST',
          dataType: 'JSON',
          data:$(this).serialize(),
      })
      .done(function(data) {
        $('.main-spinner').hide();
        $("#client-id").append(`
          <option value="${data.id}">
            ${data.name}
          </option>
        `);
        toastr.success("Client create successfully !");
        console.log("success");
      })
      .fail(function() {
        $('.main-spinner').hide();
        toastr.warning("Error with your request, Please try again !");
        console.log("error");
      })
      .always(function() {
          $("#create-new-client").modal("hide");
      }); 
  });
</script>
@endsection