@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Create")}} {{__("application.Customer")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
              <li class="breadcrumb-item"><a href="{{route('customer.index')}}">{{__("application.Customer")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Create")}} {{__("application.Customer")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(array('route' => 'customer.store','method'=>'POST')) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Name")}}:</strong>
                                    {!! Form::text('name', null, array('placeholder' => __("application.Name"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Phone")}}:</strong>
                                    {!! Form::text('phone', null, array('placeholder' => __("application.Phone"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Nationality")}}:</strong>
                                    {!! Form::text('nationality', null, array('placeholder' => __("application.Nationality"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.House")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('house_number', null, array('placeholder' => __("application.House").__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Province")}}:</strong>
                                    {!! Form::select('province',$provinces,[], array('class' => 'form-control select2','id'=>'p_province')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.Commune")}}:</strong>
                                    <select name="commune" id="p_commune" class="form-control select2">
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Village")}}:</strong>
                                    <select name="village" id="p_village" class="form-control select2">
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Nick Name")}}:</strong>
                                    {!! Form::text('nick_name', null, array('placeholder' => __("application.Nick Name"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Gender")}}:</strong>
                                    {!! Form::select('gender', ["Male"=>"Male","Female"=>"Female"],[], array('class' => 'form-control select2','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Date of Birth")}}:</strong>
                                    {!! Form::text('date_of_birth', null, array('class' => 'form-control date_picker','placeholder'=>__("application.Date of Birth"))) !!}
                                </div>

                                <div class="form-group">
                                    <strong>{{__("application.Street")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('street_number', null, array('placeholder' => __("application.Street").__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.District")}}:</strong>
                                    <select name="district" id="p_district" class="form-control select2">
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}</strong>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'5')) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
@endsection