@extends("layouts.master")
@section("content")
<style>
  .jconfirm {
    .jconfirm-holder {
      margin-right: 1rem;
      margin-left: 1rem;
    }

    .jconfirm-box {
      width: 100% !important;
      max-width: 400px;
    }
  }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Purchase")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Purchase")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('purchases.create')}}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datatable-purchase" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th>{{__('application.No')}}</th>
                      {{-- <th>{{__('application.Date')}}</th> --}}
                      <th>{{__('application.Date')}} {{__('application.Purchase')}}</th>
                      <th>{{__('application.Block')}} </th>
                      <th>{{__('application.Project')}} </th>
                      <th>{{__('application.Supplier')}}</th>
                      <th>{{__('application.Phone')}} {{__('application.Supplier')}}</th>
                      <th>{{__('application.Total')}} {{__('application.Amount')}}</th>
                      <th>{{__('application.Invoice')}}</th>
                      <th>{{__('application.Person')}} {{__('application.Recieve')}}</th>
                      <th>{{__('application.Action')}}</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
  function view_delete(obj){
      var id = $(obj).attr("purchase_id");
      $.confirm({
          title:'Are you sure ?',
          content:' ',
          theme:'modern',
          buttons:{
              cancel:{
                  btnClass:'btn btn-primary',
                  text:'Cancel',
                  action:function () {

                  }
              },
              submit:{
                  btnClass:'btn btn-danger',
                  text:"Delete",
                  action:function () {
                          window.location.replace('{{route( "purchases.delete") }}'+"?purchase_id="+id);
                  }
              },
          },
      });
  }
  function print_image(){
    $(".show-image").printThis({importCSS: false});
  }
  function close_image(){
    $(".cancel-confirm").click();
  }
  function show_image(purchase_stock_id){
    var route = "{{route('show_purchase_image',':id')}}";
    route = route.replace(":id",purchase_stock_id);
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"GET",
      dataType:"JSON",
      async:false,
      success:function(data){
        $(".main-spinner").hide();
        if(data['status']==true){
          var opt = "<button onclick='print_image()' class='btn btn-md btn-info'><i class='fa fa-print'></i></button><div class='show-image row'>";
          $.each(data['image'],function(index,value){
            opt += `<div class="col-sm-6"><img class="image-purchase" style="float:left !important;margin:10px !important;" width="330px !important" height="280px !important" src = "${value}"></div>`;
          });
          opt += "</div>";
          $.confirm({
              title: '',
              content:opt,
              closeIcon: true,
              buttons: {
                  print:{
                    text:'Print',
                    action:function(e){
                      $(".show-image").printThis({importCSS: false});
                    }
                  },
                  cancel: {
                    btnClass: 'Confirm',
                    text:'Cancel',
                    action:function(){

                    }
                  },
              },
              onContentReady: function () {
                  var self = this;
              },
              columnClass: 'medium',
          });
        }
        else{

        }
      },
      error:function(){
        $(".main-spinner").hide();
          return "Erro !"
      }
    });
  }
  $(document).ready(function() {
    $('#datatable-purchase').DataTable({
        ordering: false,    
        "serverSide": true,
        "scrollY": screen.height,
        "scrollX": true,
        "lengthMenu": [[20, 30, 50, 100,-1], [20, 30, 50, 100,'all']],
        ajax: "{{ route('get_purchase_list') }}",
        columns: 
            [
                {data: 'DT_RowIndex'}, 
                // {data: 'date'},
                {data: 'date_purchase'},
                {data: 'name'},
                {data: 'project_name'},
                {data: 'supp_name'},
                {data: 'supp_phone'},
                {data: 'total_amount'},
                {data: 'invoice_num'},
                {data: 'person_recieve'},
                {data: 'action'}
            ]

    });

    $.fn.dataTable.ext.errMode = 'throw';
});
</script>

@endsection